/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcListIpv6CidrApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcListIpv6CidrApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "GET", "/v4/ipv6/list-cidrs", "application/json");
    }

    public ListIpv6CidrResponse send(Credential credential, ListIpv6CidrRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListIpv6CidrResponse.class);
    }

    public static class ListIpv6CidrReturnObjResponse {
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="ipv6CidrBlock")
        private String ipv6CidrBlock;
        @JsonProperty(value="ipv6SegmentPoolID")
        private String ipv6SegmentPoolID;
        @JsonProperty(value="addressPoolType")
        private String addressPoolType;
        @JsonProperty(value="isp")
        private String isp;
        @JsonProperty(value="vpcIpv6PrefixLen")
        private Integer vpcIpv6PrefixLen;
        @JsonProperty(value="subnetIpv6PrefixLen")
        private Integer subnetIpv6PrefixLen;
        @JsonProperty(value="availableBlockCount")
        private Integer availableBlockCount;
        @JsonProperty(value="adminStatus")
        private Integer adminStatus;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        public void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public String getIpv6SegmentPoolID() {
            return this.ipv6SegmentPoolID;
        }

        public void setIpv6SegmentPoolID(String ipv6SegmentPoolID) {
            this.ipv6SegmentPoolID = ipv6SegmentPoolID;
        }

        public String getAddressPoolType() {
            return this.addressPoolType;
        }

        public void setAddressPoolType(String addressPoolType) {
            this.addressPoolType = addressPoolType;
        }

        public String getIsp() {
            return this.isp;
        }

        public void setIsp(String isp) {
            this.isp = isp;
        }

        public Integer getVpcIpv6PrefixLen() {
            return this.vpcIpv6PrefixLen;
        }

        public void setVpcIpv6PrefixLen(Integer vpcIpv6PrefixLen) {
            this.vpcIpv6PrefixLen = vpcIpv6PrefixLen;
        }

        public Integer getSubnetIpv6PrefixLen() {
            return this.subnetIpv6PrefixLen;
        }

        public void setSubnetIpv6PrefixLen(Integer subnetIpv6PrefixLen) {
            this.subnetIpv6PrefixLen = subnetIpv6PrefixLen;
        }

        public Integer getAvailableBlockCount() {
            return this.availableBlockCount;
        }

        public void setAvailableBlockCount(Integer availableBlockCount) {
            this.availableBlockCount = availableBlockCount;
        }

        public Integer getAdminStatus() {
            return this.adminStatus;
        }

        public void setAdminStatus(Integer adminStatus) {
            this.adminStatus = adminStatus;
        }
    }

    public static class ListIpv6CidrResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="requestID")
        private String requestID;
        @JsonProperty(value="returnObj")
        private List<ListIpv6CidrReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getRequestID() {
            return this.requestID;
        }

        public void setRequestID(String requestID) {
            this.requestID = requestID;
        }

        public List<ListIpv6CidrReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<ListIpv6CidrReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListIpv6CidrRequest {
        @JsonProperty(value="regionID")
        private String regionID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }
    }
}

