/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcListHavipApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcListHavipApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "POST", "/v4/vpc/havip/list", "application/json");
    }

    public ListHavipResponse send(Credential credential, ListHavipRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListHavipResponse.class);
    }

    public static class ListHavipReturnObjNetworkInfoResponse {
        @JsonProperty(value="eipID")
        private String eipID;

        public String getEipID() {
            return this.eipID;
        }

        public void setEipID(String eipID) {
            this.eipID = eipID;
        }
    }

    public static class ListHavipReturnObjInstanceInfoResponse {
        @JsonProperty(value="instanceName")
        private String instanceName;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="privateIp")
        private String privateIp;
        @JsonProperty(value="privateIpv6")
        private String privateIpv6;
        @JsonProperty(value="publicIp")
        private String publicIp;

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPrivateIp() {
            return this.privateIp;
        }

        public void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public String getPrivateIpv6() {
            return this.privateIpv6;
        }

        public void setPrivateIpv6(String privateIpv6) {
            this.privateIpv6 = privateIpv6;
        }

        public String getPublicIp() {
            return this.publicIp;
        }

        public void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }
    }

    public static class ListHavipReturnObjResponse {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="ipv4")
        private String ipv4;
        @JsonProperty(value="ipv6")
        private String ipv6;
        @JsonProperty(value="vpcID")
        private String vpcID;
        @JsonProperty(value="subnetID")
        private String subnetID;
        @JsonProperty(value="instanceInfo")
        private List<ListHavipReturnObjInstanceInfoResponse> instanceInfo;
        @JsonProperty(value="networkInfo")
        private List<ListHavipReturnObjNetworkInfoResponse> networkInfo;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getIpv4() {
            return this.ipv4;
        }

        public void setIpv4(String ipv4) {
            this.ipv4 = ipv4;
        }

        public String getIpv6() {
            return this.ipv6;
        }

        public void setIpv6(String ipv6) {
            this.ipv6 = ipv6;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public List<ListHavipReturnObjInstanceInfoResponse> getInstanceInfo() {
            return this.instanceInfo;
        }

        public void setInstanceInfo(List<ListHavipReturnObjInstanceInfoResponse> instanceInfo) {
            this.instanceInfo = instanceInfo;
        }

        public List<ListHavipReturnObjNetworkInfoResponse> getNetworkInfo() {
            return this.networkInfo;
        }

        public void setNetworkInfo(List<ListHavipReturnObjNetworkInfoResponse> networkInfo) {
            this.networkInfo = networkInfo;
        }
    }

    public static class ListHavipResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private List<ListHavipReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public List<ListHavipReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<ListHavipReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListHavipFiltersRequest {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="value")
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class ListHavipRequest {
        @JsonProperty(value="clientToken")
        private String clientToken;
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="projectID")
        private String projectID;
        @JsonProperty(value="filters")
        private List<ListHavipFiltersRequest> filters;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public List<ListHavipFiltersRequest> getFilters() {
            return this.filters;
        }

        public void setFilters(List<ListHavipFiltersRequest> filters) {
            this.filters = filters;
        }
    }
}

