/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcListAclApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcListAclApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "GET", "/v4/acl/list", "application/json");
    }

    public ListAclResponse send(Credential credential, ListAclRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.aclID != null) {
            ctReq.addParam("aclID", request.aclID);
            request.aclID = null;
        }
        if (request.projectID != null) {
            ctReq.addParam("projectID", request.projectID);
            request.projectID = null;
        }
        if (request.name != null) {
            ctReq.addParam("name", request.name);
            request.name = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListAclResponse.class);
    }

    public static class ListAclReturnObjAclsResponse {
        @JsonProperty(value="aclID")
        private String aclID;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="applyToPublicLb")
        private Boolean applyToPublicLb;
        @JsonProperty(value="vpcID")
        private String vpcID;
        @JsonProperty(value="enabled")
        private String enabled;
        @JsonProperty(value="inPolicyID")
        private List<String> inPolicyID;
        @JsonProperty(value="outPolicyID")
        private List<String> outPolicyID;
        @JsonProperty(value="createdAt")
        private String createdAt;
        @JsonProperty(value="updatedAt")
        private String updatedAt;
        @JsonProperty(value="subnetIDs")
        private List<String> subnetIDs;

        public String getAclID() {
            return this.aclID;
        }

        public void setAclID(String aclID) {
            this.aclID = aclID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Boolean getApplyToPublicLb() {
            return this.applyToPublicLb;
        }

        public void setApplyToPublicLb(Boolean applyToPublicLb) {
            this.applyToPublicLb = applyToPublicLb;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getEnabled() {
            return this.enabled;
        }

        public void setEnabled(String enabled) {
            this.enabled = enabled;
        }

        public List<String> getInPolicyID() {
            return this.inPolicyID;
        }

        public void setInPolicyID(List<String> inPolicyID) {
            this.inPolicyID = inPolicyID;
        }

        public List<String> getOutPolicyID() {
            return this.outPolicyID;
        }

        public void setOutPolicyID(List<String> outPolicyID) {
            this.outPolicyID = outPolicyID;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public List<String> getSubnetIDs() {
            return this.subnetIDs;
        }

        public void setSubnetIDs(List<String> subnetIDs) {
            this.subnetIDs = subnetIDs;
        }
    }

    public static class ListAclReturnObjResponse {
        @JsonProperty(value="acls")
        private List<ListAclReturnObjAclsResponse> acls;

        public List<ListAclReturnObjAclsResponse> getAcls() {
            return this.acls;
        }

        public void setAcls(List<ListAclReturnObjAclsResponse> acls) {
            this.acls = acls;
        }
    }

    public static class ListAclResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="requestID")
        private String requestID;
        @JsonProperty(value="returnObj")
        private ListAclReturnObjResponse returnObj;
        @JsonProperty(value="totalCount")
        private Integer totalCount;
        @JsonProperty(value="currentCount")
        private Integer currentCount;
        @JsonProperty(value="totalPage")
        private Integer totalPage;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getRequestID() {
            return this.requestID;
        }

        public void setRequestID(String requestID) {
            this.requestID = requestID;
        }

        public ListAclReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListAclReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class ListAclRequest {
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="aclID")
        private String aclID;
        @JsonProperty(value="projectID")
        private String projectID;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="pageNumber")
        private Integer pageNumber;
        @JsonProperty(value="pageNo")
        private Integer pageNo;
        @JsonProperty(value="pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getAclID() {
            return this.aclID;
        }

        public void setAclID(String aclID) {
            this.aclID = aclID;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }
}

