/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;

public class CtvpcCreateVpcApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcCreateVpcApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "POST", "/v4/vpc/create", "application/json");
    }

    public CreateVpc1Response send(Credential credential, CreateVpc1Request request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateVpc1Response.class);
    }

    public static class CreateVpc1ReturnObjResponse {
        @JsonProperty(value="vpcID")
        private String vpcID;
        @JsonProperty(value="createdAt")
        private String createdAt;
        @JsonProperty(value="updatedAt")
        private String updatedAt;

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }
    }

    public static class CreateVpc1Response {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private CreateVpc1ReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public CreateVpc1ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateVpc1ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateVpc1Request {
        @JsonProperty(value="clientToken")
        private String clientToken;
        @JsonProperty(value="projectID")
        private String projectID;
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="CIDR")
        private String cIDR;
        @JsonProperty(value="enableIpv6")
        private Boolean enableIpv6;
        @JsonProperty(value="ipv6SegmentPoolID")
        private String ipv6SegmentPoolID;
        @JsonProperty(value="addressPoolType")
        private String addressPoolType;
        @JsonProperty(value="ipv6Cidr")
        private String ipv6Cidr;
        @JsonProperty(value="ipv6Isp")
        private String ipv6Isp;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getCIDR() {
            return this.cIDR;
        }

        public void setCIDR(String cIDR) {
            this.cIDR = cIDR;
        }

        public Boolean getEnableIpv6() {
            return this.enableIpv6;
        }

        public void setEnableIpv6(Boolean enableIpv6) {
            this.enableIpv6 = enableIpv6;
        }

        public String getIpv6SegmentPoolID() {
            return this.ipv6SegmentPoolID;
        }

        public void setIpv6SegmentPoolID(String ipv6SegmentPoolID) {
            this.ipv6SegmentPoolID = ipv6SegmentPoolID;
        }

        public String getAddressPoolType() {
            return this.addressPoolType;
        }

        public void setAddressPoolType(String addressPoolType) {
            this.addressPoolType = addressPoolType;
        }

        public String getIpv6Cidr() {
            return this.ipv6Cidr;
        }

        public void setIpv6Cidr(String ipv6Cidr) {
            this.ipv6Cidr = ipv6Cidr;
        }

        public String getIpv6Isp() {
            return this.ipv6Isp;
        }

        public void setIpv6Isp(String ipv6Isp) {
            this.ipv6Isp = ipv6Isp;
        }
    }
}

