/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcCreateSgIngressRuleApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcCreateSgIngressRuleApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "POST", "/v4/vpc/create-security-group-ingress", "application/json");
    }

    public CreateSgIngressRuleResponse send(Credential credential, CreateSgIngressRuleRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateSgIngressRuleResponse.class);
    }

    public static class CreateSgIngressRuleReturnObjResponse {
        @JsonProperty(value="sgRuleIDs")
        private List<String> sgRuleIDs;

        public List<String> getSgRuleIDs() {
            return this.sgRuleIDs;
        }

        public void setSgRuleIDs(List<String> sgRuleIDs) {
            this.sgRuleIDs = sgRuleIDs;
        }
    }

    public static class CreateSgIngressRuleResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private CreateSgIngressRuleReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public CreateSgIngressRuleReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateSgIngressRuleReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateSgIngressRuleSecurityGroupRulesRequest {
        @JsonProperty(value="direction")
        private String direction;
        @JsonProperty(value="remoteType")
        private Integer remoteType;
        @JsonProperty(value="remoteSecurityGroupID")
        private String remoteSecurityGroupID;
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="priority")
        private Integer priority;
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="ethertype")
        private String ethertype;
        @JsonProperty(value="destCidrIp")
        private String destCidrIp;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="range")
        private String range;

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public Integer getRemoteType() {
            return this.remoteType;
        }

        public void setRemoteType(Integer remoteType) {
            this.remoteType = remoteType;
        }

        public String getRemoteSecurityGroupID() {
            return this.remoteSecurityGroupID;
        }

        public void setRemoteSecurityGroupID(String remoteSecurityGroupID) {
            this.remoteSecurityGroupID = remoteSecurityGroupID;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getEthertype() {
            return this.ethertype;
        }

        public void setEthertype(String ethertype) {
            this.ethertype = ethertype;
        }

        public String getDestCidrIp() {
            return this.destCidrIp;
        }

        public void setDestCidrIp(String destCidrIp) {
            this.destCidrIp = destCidrIp;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }
    }

    public static class CreateSgIngressRuleRequest {
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="securityGroupID")
        private String securityGroupID;
        @JsonProperty(value="securityGroupRules")
        private List<CreateSgIngressRuleSecurityGroupRulesRequest> securityGroupRules;
        @JsonProperty(value="clientToken")
        private String clientToken;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        public List<CreateSgIngressRuleSecurityGroupRulesRequest> getSecurityGroupRules() {
            return this.securityGroupRules;
        }

        public void setSecurityGroupRules(List<CreateSgIngressRuleSecurityGroupRulesRequest> securityGroupRules) {
            this.securityGroupRules = securityGroupRules;
        }

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }
    }
}

