/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcCreatePortApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcCreatePortApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "POST", "/v4/ports/create", "application/json");
    }

    public CreatePortResponse send(Credential credential, CreatePortRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreatePortResponse.class);
    }

    public static class CreatePortReturnObjResponse {
        @JsonProperty(value="vpcID")
        private String vpcID;
        @JsonProperty(value="subnetID")
        private String subnetID;
        @JsonProperty(value="networkInterfaceID")
        private String networkInterfaceID;
        @JsonProperty(value="networkInterfaceName")
        private String networkInterfaceName;
        @JsonProperty(value="macAddress")
        private String macAddress;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="ipv6Address")
        private List<String> ipv6Address;
        @JsonProperty(value="securityGroupIds")
        private List<String> securityGroupIds;
        @JsonProperty(value="secondaryPrivateIps")
        private List<String> secondaryPrivateIps;
        @JsonProperty(value="privateIpAddress")
        private String privateIpAddress;
        @JsonProperty(value="instanceOwnerID")
        private String instanceOwnerID;
        @JsonProperty(value="instanceType")
        private String instanceType;
        @JsonProperty(value="instanceID")
        private String instanceID;
        @JsonProperty(value="createdAt")
        private String createdAt;
        @JsonProperty(value="updatedAt")
        private String updatedAt;

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public String getNetworkInterfaceID() {
            return this.networkInterfaceID;
        }

        public void setNetworkInterfaceID(String networkInterfaceID) {
            this.networkInterfaceID = networkInterfaceID;
        }

        public String getNetworkInterfaceName() {
            return this.networkInterfaceName;
        }

        public void setNetworkInterfaceName(String networkInterfaceName) {
            this.networkInterfaceName = networkInterfaceName;
        }

        public String getMacAddress() {
            return this.macAddress;
        }

        public void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<String> getIpv6Address() {
            return this.ipv6Address;
        }

        public void setIpv6Address(List<String> ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        public List<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        public void setSecurityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
        }

        public List<String> getSecondaryPrivateIps() {
            return this.secondaryPrivateIps;
        }

        public void setSecondaryPrivateIps(List<String> secondaryPrivateIps) {
            this.secondaryPrivateIps = secondaryPrivateIps;
        }

        public String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public String getInstanceOwnerID() {
            return this.instanceOwnerID;
        }

        public void setInstanceOwnerID(String instanceOwnerID) {
            this.instanceOwnerID = instanceOwnerID;
        }

        public String getInstanceType() {
            return this.instanceType;
        }

        public void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public String getInstanceID() {
            return this.instanceID;
        }

        public void setInstanceID(String instanceID) {
            this.instanceID = instanceID;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }
    }

    public static class CreatePortResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private CreatePortReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public CreatePortReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreatePortReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreatePortRequest {
        @JsonProperty(value="clientToken")
        private String clientToken;
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="subnetID")
        private String subnetID;
        @JsonProperty(value="primaryPrivateIp")
        private String primaryPrivateIp;
        @JsonProperty(value="ipv6Addresses")
        private List<String> ipv6Addresses;
        @JsonProperty(value="securityGroupIds")
        private List<String> securityGroupIds;
        @JsonProperty(value="secondaryPrivateIpCount")
        private Integer secondaryPrivateIpCount;
        @JsonProperty(value="secondaryPrivateIps")
        private List<String> secondaryPrivateIps;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public String getPrimaryPrivateIp() {
            return this.primaryPrivateIp;
        }

        public void setPrimaryPrivateIp(String primaryPrivateIp) {
            this.primaryPrivateIp = primaryPrivateIp;
        }

        public List<String> getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        public void setIpv6Addresses(List<String> ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
        }

        public List<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        public void setSecurityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
        }

        public Integer getSecondaryPrivateIpCount() {
            return this.secondaryPrivateIpCount;
        }

        public void setSecondaryPrivateIpCount(Integer secondaryPrivateIpCount) {
            this.secondaryPrivateIpCount = secondaryPrivateIpCount;
        }

        public List<String> getSecondaryPrivateIps() {
            return this.secondaryPrivateIps;
        }

        public void setSecondaryPrivateIps(List<String> secondaryPrivateIps) {
            this.secondaryPrivateIps = secondaryPrivateIps;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

