/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;

public class CtvpcCreateHavipApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcCreateHavipApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "POST", "/v4/vpc/havip/create", "application/json");
    }

    public CreateHavipResponse send(Credential credential, CreateHavipRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateHavipResponse.class);
    }

    public static class CreateHavipReturnObjResponse {
        @JsonProperty(value="uuid")
        private String uuid;
        @JsonProperty(value="ipv4")
        private String ipv4;
        @JsonProperty(value="ipv6")
        private String ipv6;

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String getIpv4() {
            return this.ipv4;
        }

        public void setIpv4(String ipv4) {
            this.ipv4 = ipv4;
        }

        public String getIpv6() {
            return this.ipv6;
        }

        public void setIpv6(String ipv6) {
            this.ipv6 = ipv6;
        }
    }

    public static class CreateHavipResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private CreateHavipReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public CreateHavipReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateHavipReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateHavipRequest {
        @JsonProperty(value="clientToken")
        private String clientToken;
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="networkID")
        private String networkID;
        @JsonProperty(value="subnetID")
        private String subnetID;
        @JsonProperty(value="ipAddress")
        private String ipAddress;
        @JsonProperty(value="vipType")
        private String vipType;
        @JsonProperty(value="description")
        private String description;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getNetworkID() {
            return this.networkID;
        }

        public void setNetworkID(String networkID) {
            this.networkID = networkID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public String getVipType() {
            return this.vipType;
        }

        public void setVipType(String vipType) {
            this.vipType = vipType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

