/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcCreateAclRuleApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcCreateAclRuleApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "POST", "/v4/acl-rule/create", "application/json");
    }

    public CreateAclRuleResponse send(Credential credential, CreateAclRuleRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateAclRuleResponse.class);
    }

    public static class CreateAclRuleReturnObjResponse {
        @JsonProperty(value="aclID")
        private String aclID;

        public String getAclID() {
            return this.aclID;
        }

        public void setAclID(String aclID) {
            this.aclID = aclID;
        }
    }

    public static class CreateAclRuleResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private CreateAclRuleReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public CreateAclRuleReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateAclRuleReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateAclRuleRulesRequest {
        @JsonProperty(value="direction")
        private String direction;
        @JsonProperty(value="priority")
        private Integer priority;
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="ipVersion")
        private String ipVersion;
        @JsonProperty(value="destinationPort")
        private String destinationPort;
        @JsonProperty(value="sourcePort")
        private String sourcePort;
        @JsonProperty(value="sourceIpAddress")
        private String sourceIpAddress;
        @JsonProperty(value="destinationIpAddress")
        private String destinationIpAddress;
        @JsonProperty(value="action")
        private String action;
        @JsonProperty(value="enabled")
        private String enabled;
        @JsonProperty(value="description")
        private String description;

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getIpVersion() {
            return this.ipVersion;
        }

        public void setIpVersion(String ipVersion) {
            this.ipVersion = ipVersion;
        }

        public String getDestinationPort() {
            return this.destinationPort;
        }

        public void setDestinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
        }

        public String getSourcePort() {
            return this.sourcePort;
        }

        public void setSourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
        }

        public String getSourceIpAddress() {
            return this.sourceIpAddress;
        }

        public void setSourceIpAddress(String sourceIpAddress) {
            this.sourceIpAddress = sourceIpAddress;
        }

        public String getDestinationIpAddress() {
            return this.destinationIpAddress;
        }

        public void setDestinationIpAddress(String destinationIpAddress) {
            this.destinationIpAddress = destinationIpAddress;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getEnabled() {
            return this.enabled;
        }

        public void setEnabled(String enabled) {
            this.enabled = enabled;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class CreateAclRuleRequest {
        @JsonProperty(value="clientToken")
        private String clientToken;
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="aclID")
        private String aclID;
        @JsonProperty(value="rules")
        private List<CreateAclRuleRulesRequest> rules;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getAclID() {
            return this.aclID;
        }

        public void setAclID(String aclID) {
            this.aclID = aclID;
        }

        public List<CreateAclRuleRulesRequest> getRules() {
            return this.rules;
        }

        public void setRules(List<CreateAclRuleRulesRequest> rules) {
            this.rules = rules;
        }
    }
}

