/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;

public class CtvpcBindHavipApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcBindHavipApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "POST", "/v4/vpc/havip/bind", "application/json");
    }

    public BindHavipResponse send(Credential credential, BindHavipRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(BindHavipResponse.class);
    }

    public static class BindHavipReturnObjResponse {
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="message")
        private String message;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    public static class BindHavipResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private BindHavipReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public BindHavipReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(BindHavipReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class BindHavipRequest {
        @JsonProperty(value="clientToken")
        private String clientToken;
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="haVipID")
        private String haVipID;
        @JsonProperty(value="networkInterfaceID")
        private String networkInterfaceID;
        @JsonProperty(value="instanceID")
        private String instanceID;
        @JsonProperty(value="floatingID")
        private String floatingID;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public String getHaVipID() {
            return this.haVipID;
        }

        public void setHaVipID(String haVipID) {
            this.haVipID = haVipID;
        }

        public String getNetworkInterfaceID() {
            return this.networkInterfaceID;
        }

        public void setNetworkInterfaceID(String networkInterfaceID) {
            this.networkInterfaceID = networkInterfaceID;
        }

        public String getInstanceID() {
            return this.instanceID;
        }

        public void setInstanceID(String instanceID) {
            this.instanceID = instanceID;
        }

        public String getFloatingID() {
            return this.floatingID;
        }

        public void setFloatingID(String floatingID) {
            this.floatingID = floatingID;
        }
    }
}

