/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcBatchCheckPortStatusApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcBatchCheckPortStatusApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "GET", "/v4/ports/check-status-batch", "application/json");
    }

    public BatchCheckPortStatusResponse send(Credential credential, BatchCheckPortStatusRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.portIDs != null) {
            ctReq.addParam("portIDs", request.portIDs);
            request.portIDs = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(BatchCheckPortStatusResponse.class);
    }

    public static class BatchCheckPortStatusReturnObjResponse {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="status")
        private String status;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }

    public static class BatchCheckPortStatusResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private List<BatchCheckPortStatusReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public List<BatchCheckPortStatusReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<BatchCheckPortStatusReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class BatchCheckPortStatusRequest {
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="portIDs")
        private String portIDs;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getPortIDs() {
            return this.portIDs;
        }

        public void setPortIDs(String portIDs) {
            this.portIDs = portIDs;
        }
    }
}

