/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;

public class CtvpcAclCloneApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcAclCloneApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "POST", "/v4/acl/clone", "application/json");
    }

    public AclCloneResponse send(Credential credential, AclCloneRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(AclCloneResponse.class);
    }

    public static class AclCloneReturnObjResponse {
        @JsonProperty(value="aclID")
        private String aclID;
        @JsonProperty(value="name")
        private String name;

        public String getAclID() {
            return this.aclID;
        }

        public void setAclID(String aclID) {
            this.aclID = aclID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class AclCloneResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="requestID")
        private String requestID;
        @JsonProperty(value="returnObj")
        private AclCloneReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getRequestID() {
            return this.requestID;
        }

        public void setRequestID(String requestID) {
            this.requestID = requestID;
        }

        public AclCloneReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(AclCloneReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class AclCloneRequest {
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="destRegionID")
        private String destRegionID;
        @JsonProperty(value="srcAclID")
        private String srcAclID;
        @JsonProperty(value="vpcID")
        private String vpcID;
        @JsonProperty(value="name")
        private String name;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getDestRegionID() {
            return this.destRegionID;
        }

        public void setDestRegionID(String destRegionID) {
            this.destRegionID = destRegionID;
        }

        public String getSrcAclID() {
            return this.srcAclID;
        }

        public void setSrcAclID(String srcAclID) {
            this.srcAclID = srcAclID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

