package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 弹性网卡列表 */
public class CtvpcVpcListPortApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcVpcListPortApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/ports/list", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public VpcListPortResponse send(Credential credential, VpcListPortRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.vpcID != null) {
            ctReq.addParam("vpcID", request.vpcID);
            request.vpcID = null;
        }
        if (request.deviceID != null) {
            ctReq.addParam("deviceID", request.deviceID);
            request.deviceID = null;
        }
        if (request.subnetID != null) {
            ctReq.addParam("subnetID", request.subnetID);
            request.subnetID = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.nextToken != null) {
            ctReq.addParam("nextToken", request.nextToken);
            request.nextToken = null;
        }
        if (request.maxResults != null) {
            ctReq.addParam("maxResults", String.valueOf(request.maxResults));
            request.maxResults = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(VpcListPortResponse.class);
    }

    public static class VpcListPortRequest {
        /** 区域id */
        @JsonProperty("regionID")
        private String regionID;

        /** 所属vpc id */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 关联设备id */
        @JsonProperty("deviceID")
        private String deviceID;

        /** 所属子网id */
        @JsonProperty("subnetID")
        private String subnetID;

        /** 列表的页码，默认值为 1。 */
        @JsonProperty("pageNumber")
        private Integer pageNumber;

        /** 列表的页码，默认值为 1, 推荐使用该字段, pageNumber 后续会废弃 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 分页查询时每页的行数，最大值为 50，默认值为 10。 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 下一页游标 */
        @JsonProperty("nextToken")
        private String nextToken;

        /** 最大数量 */
        @JsonProperty("maxResults")
        private Integer maxResults;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getDeviceID() {
            return this.deviceID;
        }

        public void setDeviceID(String deviceID) {
            this.deviceID = deviceID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getNextToken() {
            return this.nextToken;
        }

        public void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public Integer getMaxResults() {
            return this.maxResults;
        }

        public void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }
    }

    public static class VpcListPortResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private List<VpcListPortReturnObjResponse> returnObj;

        /** 列表条目数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 分页查询时每页的行数。 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public List<VpcListPortReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<VpcListPortReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class VpcListPortReturnObjResponse {
        /** 虚拟网名称 */
        @JsonProperty("networkInterfaceName")
        private String networkInterfaceName;

        /** 虚拟网id */
        @JsonProperty("networkInterfaceID")
        private String networkInterfaceID;

        /** 所属vpc */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 所属子网id */
        @JsonProperty("subnetID")
        private String subnetID;

        /** 网卡类型: 0 主网卡， 1 弹性网卡 */
        @JsonProperty("role")
        private Integer role;

        /** mac地址 */
        @JsonProperty("macAddress")
        private String macAddress;

        /** 主ip */
        @JsonProperty("primaryPrivateIp")
        private String primaryPrivateIp;

        /** ipv6地址 */
        @JsonProperty("ipv6Addresses")
        private List<String> ipv6Addresses;

        /** 关联的设备id */
        @JsonProperty("instanceID")
        private String instanceID;

        /** 设备类型 VM(云主机), BM(裸金属), LB(弹性负载均衡), CBM(标准裸金属) */
        @JsonProperty("instanceType")
        private String instanceType;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** 安全组ID列表 */
        @JsonProperty("securityGroupIds")
        private List<String> securityGroupIds;

        /** 辅助私网IP */
        @JsonProperty("secondaryPrivateIps")
        private List<String> secondaryPrivateIps;

        /** 是否启用DOWN, UP */
        @JsonProperty("adminStatus")
        private String adminStatus;

        public String getNetworkInterfaceName() {
            return this.networkInterfaceName;
        }

        public void setNetworkInterfaceName(String networkInterfaceName) {
            this.networkInterfaceName = networkInterfaceName;
        }

        public String getNetworkInterfaceID() {
            return this.networkInterfaceID;
        }

        public void setNetworkInterfaceID(String networkInterfaceID) {
            this.networkInterfaceID = networkInterfaceID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public Integer getRole() {
            return this.role;
        }

        public void setRole(Integer role) {
            this.role = role;
        }

        public String getMacAddress() {
            return this.macAddress;
        }

        public void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public String getPrimaryPrivateIp() {
            return this.primaryPrivateIp;
        }

        public void setPrimaryPrivateIp(String primaryPrivateIp) {
            this.primaryPrivateIp = primaryPrivateIp;
        }

        public List<String> getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        public void setIpv6Addresses(List<String> ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
        }

        public String getInstanceID() {
            return this.instanceID;
        }

        public void setInstanceID(String instanceID) {
            this.instanceID = instanceID;
        }

        public String getInstanceType() {
            return this.instanceType;
        }

        public void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        public void setSecurityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
        }

        public List<String> getSecondaryPrivateIps() {
            return this.secondaryPrivateIps;
        }

        public void setSecondaryPrivateIps(List<String> secondaryPrivateIps) {
            this.secondaryPrivateIps = secondaryPrivateIps;
        }

        public String getAdminStatus() {
            return this.adminStatus;
        }

        public void setAdminStatus(String adminStatus) {
            this.adminStatus = adminStatus;
        }
    }
}
