package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 创建子网。 */
public class CtvpcVpcCreateSubnetApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcVpcCreateSubnetApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v4/vpc/create-subnet", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public VpcCreateSubnetResponse send(Credential credential, VpcCreateSubnetRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(VpcCreateSubnetResponse.class);
    }

    public static class VpcCreateSubnetRequest {
        /** 客户端存根，用于保证订单幂等性, 长度 1 - 64 */
        @JsonProperty("clientToken")
        private String clientToken;

        /** 资源池 ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 虚拟私有云 ID */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 支持拉丁字母、中文、数字，下划线，连字符，中文 / 英文字母开头，不能以 http: / https: 开头，长度 2 - 32 */
        @JsonProperty("name")
        private String name;

        /**
         * 支持拉丁字母、中文、数字, 特殊字符：~!@#$%^&*()_-+= <>?:{},./;'[\]·！@#￥%……&*（） ——
         * -+={}\|《》？：“”【】、；‘'，。、，不能以 http: / https: 开头，长度 0 - 128
         */
        @JsonProperty("description")
        private String description;

        /** 子网网段 */
        @JsonProperty("CIDR")
        private String cIDR;

        /** 是否开启 IPv6 网段。取值：false（默认值）:不开启，true: 开启 */
        @JsonProperty("enableIpv6")
        private Boolean enableIpv6;

        /** 子网 dns 列表, 最多同时支持 4 个 dns 地址 */
        @JsonProperty("dnsList")
        private List<String> dnsList;

        /** 子网网关 IP */
        @JsonProperty("subnetGatewayIP")
        private String subnetGatewayIP;

        /** 子网类型：common（普通子网）/ cbm（裸金属子网），默认为普通子网 */
        @JsonProperty("subnetType")
        private String subnetType;

        /** dhcpIP,和网关IP不能相同 */
        @JsonProperty("dhcpIP")
        private String dhcpIP;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getCIDR() {
            return this.cIDR;
        }

        public void setCIDR(String cIDR) {
            this.cIDR = cIDR;
        }

        public Boolean getEnableIpv6() {
            return this.enableIpv6;
        }

        public void setEnableIpv6(Boolean enableIpv6) {
            this.enableIpv6 = enableIpv6;
        }

        public List<String> getDnsList() {
            return this.dnsList;
        }

        public void setDnsList(List<String> dnsList) {
            this.dnsList = dnsList;
        }

        public String getSubnetGatewayIP() {
            return this.subnetGatewayIP;
        }

        public void setSubnetGatewayIP(String subnetGatewayIP) {
            this.subnetGatewayIP = subnetGatewayIP;
        }

        public String getSubnetType() {
            return this.subnetType;
        }

        public void setSubnetType(String subnetType) {
            this.subnetType = subnetType;
        }

        public String getDhcpIP() {
            return this.dhcpIP;
        }

        public void setDhcpIP(String dhcpIP) {
            this.dhcpIP = dhcpIP;
        }
    }

    public static class VpcCreateSubnetResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private VpcCreateSubnetReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public VpcCreateSubnetReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(VpcCreateSubnetReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class VpcCreateSubnetReturnObjResponse {
        /** subnet 示例 ID */
        @JsonProperty("subnetID")
        private String subnetID;

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }
    }
}
