package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 修改路由表规则 */
public class CtvpcUpdateRouteTableRulesAttributeApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcUpdateRouteTableRulesAttributeApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/vpc/route-table/modify-rules",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateRouteTableRulesAttributeResponse send(
            Credential credential, UpdateRouteTableRulesAttributeRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateRouteTableRulesAttributeResponse.class);
    }

    public static class UpdateRouteTableRulesAttributeRequest {
        /** 客户端存根，用于保证订单幂等性, 长度 1 - 64 */
        @JsonProperty("clientToken")
        private String clientToken;

        /** 区域id */
        @JsonProperty("regionID")
        private String regionID;

        /** 路由表 id */
        @JsonProperty("routeTableID")
        private String routeTableID;

        /** 路由表规则列表 */
        @JsonProperty("routeRules")
        private List<UpdateRouteTableRulesAttributeRouteRulesRequest> routeRules;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getRouteTableID() {
            return this.routeTableID;
        }

        public void setRouteTableID(String routeTableID) {
            this.routeTableID = routeTableID;
        }

        public List<UpdateRouteTableRulesAttributeRouteRulesRequest> getRouteRules() {
            return this.routeRules;
        }

        public void setRouteRules(
                List<UpdateRouteTableRulesAttributeRouteRulesRequest> routeRules) {
            this.routeRules = routeRules;
        }
    }

    public static class UpdateRouteTableRulesAttributeRouteRulesRequest {
        /** 下一跳设备 id */
        @JsonProperty("nextHopID")
        private String nextHopID;

        /** vpcpeering / havip / bm / vm / natgw/ igw /igw6 / dc / ticc / vpngw / enic */
        @JsonProperty("nextHopType")
        private String nextHopType;

        /** 无类别域间路由 */
        @JsonProperty("destination")
        private String destination;

        /** 4 标识 ipv4, 6 标识 ipv6 */
        @JsonProperty("ipVersion")
        private Integer ipVersion;

        /**
         * 规则描述,支持拉丁字母、中文、数字, 特殊字符：~!@#$%^&*()_-+= <>?:'{},./;'[,]·！@#￥%……&*（） ——
         * -+={},《》？：“”【】、；‘'，。、，不能以 http: / https: 开头，长度 0 - 128
         */
        @JsonProperty("description")
        private String description;

        /** 路由规则 id */
        @JsonProperty("routeRuleID")
        private String routeRuleID;

        public String getNextHopID() {
            return this.nextHopID;
        }

        public void setNextHopID(String nextHopID) {
            this.nextHopID = nextHopID;
        }

        public String getNextHopType() {
            return this.nextHopType;
        }

        public void setNextHopType(String nextHopType) {
            this.nextHopType = nextHopType;
        }

        public String getDestination() {
            return this.destination;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        public Integer getIpVersion() {
            return this.ipVersion;
        }

        public void setIpVersion(Integer ipVersion) {
            this.ipVersion = ipVersion;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getRouteRuleID() {
            return this.routeRuleID;
        }

        public void setRouteRuleID(String routeRuleID) {
            this.routeRuleID = routeRuleID;
        }
    }

    public static class UpdateRouteTableRulesAttributeResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }
    }
}
