package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 修改 Acl 规则列表属性 */
public class CtvpcUpdateAclRuleAttributeApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcUpdateAclRuleAttributeApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v4/acl-rule/update", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateAclRuleAttributeResponse send(
            Credential credential, UpdateAclRuleAttributeRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateAclRuleAttributeResponse.class);
    }

    public static class UpdateAclRuleAttributeRequest {
        /** 客户端存根，用于保证订单幂等性。要求单个云平台账户内唯一 */
        @JsonProperty("clientToken")
        private String clientToken;

        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** aclID */
        @JsonProperty("aclID")
        private String aclID;

        /** rule 规则数组 */
        @JsonProperty("rules")
        private List<UpdateAclRuleAttributeRulesRequest> rules;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getAclID() {
            return this.aclID;
        }

        public void setAclID(String aclID) {
            this.aclID = aclID;
        }

        public List<UpdateAclRuleAttributeRulesRequest> getRules() {
            return this.rules;
        }

        public void setRules(List<UpdateAclRuleAttributeRulesRequest> rules) {
            this.rules = rules;
        }
    }

    public static class UpdateAclRuleAttributeRulesRequest {
        /** aclRuleID */
        @JsonProperty("aclRuleID")
        private String aclRuleID;

        /** 类型,ingress, egress */
        @JsonProperty("direction")
        private String direction;

        /** 优先级 1 - 32766，不填默认100 */
        @JsonProperty("priority")
        private Integer priority;

        /** all, icmp, tcp, udp, gre, icmp6 */
        @JsonProperty("protocol")
        private String protocol;

        /** ipv4, ipv6 */
        @JsonProperty("ipVersion")
        private String ipVersion;

        /** 开始和结束port以:隔开 */
        @JsonProperty("destinationPort")
        private String destinationPort;

        /** 开始和结束port以:隔开 */
        @JsonProperty("sourcePort")
        private String sourcePort;

        /** 源地址 */
        @JsonProperty("sourceIpAddress")
        private String sourceIpAddress;

        /** 目的地址 */
        @JsonProperty("destinationIpAddress")
        private String destinationIpAddress;

        /** accept, drop */
        @JsonProperty("action")
        private String action;

        /** disable, enable */
        @JsonProperty("enabled")
        private String enabled;

        /**
         * 支持拉丁字母、中文、数字, 特殊字符：~!@#$%^&*()_-+= <>?:'{},./;'[,]·！@#￥%……&*（） ——
         * -+={},《》？：“”【】、；‘'，。、，不能以 http: / https: 开头，长度 0 - 128
         */
        @JsonProperty("description")
        private String description;

        public String getAclRuleID() {
            return this.aclRuleID;
        }

        public void setAclRuleID(String aclRuleID) {
            this.aclRuleID = aclRuleID;
        }

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getIpVersion() {
            return this.ipVersion;
        }

        public void setIpVersion(String ipVersion) {
            this.ipVersion = ipVersion;
        }

        public String getDestinationPort() {
            return this.destinationPort;
        }

        public void setDestinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
        }

        public String getSourcePort() {
            return this.sourcePort;
        }

        public void setSourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
        }

        public String getSourceIpAddress() {
            return this.sourceIpAddress;
        }

        public void setSourceIpAddress(String sourceIpAddress) {
            this.sourceIpAddress = sourceIpAddress;
        }

        public String getDestinationIpAddress() {
            return this.destinationIpAddress;
        }

        public void setDestinationIpAddress(String destinationIpAddress) {
            this.destinationIpAddress = destinationIpAddress;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getEnabled() {
            return this.enabled;
        }

        public void setEnabled(String enabled) {
            this.enabled = enabled;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class UpdateAclRuleAttributeResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private UpdateAclRuleAttributeReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public UpdateAclRuleAttributeReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateAclRuleAttributeReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class UpdateAclRuleAttributeReturnObjResponse {
        /** aclID */
        @JsonProperty("aclID")
        private String aclID;

        public String getAclID() {
            return this.aclID;
        }

        public void setAclID(String aclID) {
            this.aclID = aclID;
        }
    }
}
