package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询用户专有网络 */
public class CtvpcShowVpcApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcShowVpcApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(ENDPOINT_NAME, "GET", "/v4/vpc/query", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ShowVpcResponse send(Credential credential, ShowVpcRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.vpcID != null) {
            ctReq.addParam("vpcID", request.vpcID);
            request.vpcID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ShowVpcResponse.class);
    }

    public static class ShowVpcRequest {
        /** 资源池 ID */
        @JsonProperty("regionID")
        private String regionID;

        /** VPC 的 ID */
        @JsonProperty("vpcID")
        private String vpcID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }
    }

    public static class ShowVpcResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private ShowVpcReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ShowVpcReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ShowVpcReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ShowVpcReturnObjResponse {
        /** vpc 示例 ID */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 名称 */
        @JsonProperty("name")
        private String name;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** 子网 */
        @JsonProperty("CIDR")
        private String cIDR;

        /** 是否开启 ipv6 */
        @JsonProperty("ipv6Enabled")
        private Boolean ipv6Enabled;

        /** 是否开启 ipv6 */
        @JsonProperty("enableIpv6")
        private Boolean enableIpv6;

        /** ipv6 子网列表 */
        @JsonProperty("ipv6CIDRS")
        private List<String> ipv6CIDRS;

        /** 子网 id 列表 */
        @JsonProperty("subnetIDs")
        private List<String> subnetIDs;

        /** 网关 id 列表 */
        @JsonProperty("natGatewayIDs")
        private List<String> natGatewayIDs;

        /** 附加网段 */
        @JsonProperty("secondaryCIDRS")
        private List<String> secondaryCIDRS;

        /** 企业项目 ID，默认为0 */
        @JsonProperty("projectID")
        private String projectID;

        /** VPC关联的dhcp选项集 */
        @JsonProperty("dhcpOptionsSetID")
        private String dhcpOptionsSetID;

        /** vni */
        @JsonProperty("vni")
        private Integer vni;

        /** 是否开启 dns host name */
        @JsonProperty("dnsHostnamesEnabled")
        private Integer dnsHostnamesEnabled;

        /** 创建时间 */
        @JsonProperty("createdAt")
        private String createdAt;

        /** 更新时间 */
        @JsonProperty("updatedAt")
        private String updatedAt;

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getCIDR() {
            return this.cIDR;
        }

        public void setCIDR(String cIDR) {
            this.cIDR = cIDR;
        }

        public Boolean getIpv6Enabled() {
            return this.ipv6Enabled;
        }

        public void setIpv6Enabled(Boolean ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
        }

        public Boolean getEnableIpv6() {
            return this.enableIpv6;
        }

        public void setEnableIpv6(Boolean enableIpv6) {
            this.enableIpv6 = enableIpv6;
        }

        public List<String> getIpv6CIDRS() {
            return this.ipv6CIDRS;
        }

        public void setIpv6CIDRS(List<String> ipv6CIDRS) {
            this.ipv6CIDRS = ipv6CIDRS;
        }

        public List<String> getSubnetIDs() {
            return this.subnetIDs;
        }

        public void setSubnetIDs(List<String> subnetIDs) {
            this.subnetIDs = subnetIDs;
        }

        public List<String> getNatGatewayIDs() {
            return this.natGatewayIDs;
        }

        public void setNatGatewayIDs(List<String> natGatewayIDs) {
            this.natGatewayIDs = natGatewayIDs;
        }

        public List<String> getSecondaryCIDRS() {
            return this.secondaryCIDRS;
        }

        public void setSecondaryCIDRS(List<String> secondaryCIDRS) {
            this.secondaryCIDRS = secondaryCIDRS;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public String getDhcpOptionsSetID() {
            return this.dhcpOptionsSetID;
        }

        public void setDhcpOptionsSetID(String dhcpOptionsSetID) {
            this.dhcpOptionsSetID = dhcpOptionsSetID;
        }

        public Integer getVni() {
            return this.vni;
        }

        public void setVni(Integer vni) {
            this.vni = vni;
        }

        public Integer getDnsHostnamesEnabled() {
            return this.dnsHostnamesEnabled;
        }

        public void setDnsHostnamesEnabled(Integer dnsHostnamesEnabled) {
            this.dnsHostnamesEnabled = dnsHostnamesEnabled;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }
    }
}
