package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询用户专有网络 VPC 下子网详情。 */
public class CtvpcShowSubnetApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcShowSubnetApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/vpc/query-subnet", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ShowSubnetResponse send(Credential credential, ShowSubnetRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.subnetID != null) {
            ctReq.addParam("subnetID", request.subnetID);
            request.subnetID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ShowSubnetResponse.class);
    }

    public static class ShowSubnetRequest {
        /** 资源池 ID */
        @JsonProperty("regionID")
        private String regionID;

        /** subnet 的 ID */
        @JsonProperty("subnetID")
        private String subnetID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }
    }

    public static class ShowSubnetResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private ShowSubnetReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ShowSubnetReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ShowSubnetReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ShowSubnetReturnObjResponse {
        /** subnet ID */
        @JsonProperty("subnetID")
        private String subnetID;

        /** 名称 */
        @JsonProperty("name")
        private String name;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** VpcID */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 子网所在的可用区名 */
        @JsonProperty("availabilityZones")
        private List<String> availabilityZones;

        /** 子网路由表 ID */
        @JsonProperty("routeTableID")
        private String routeTableID;

        /** 子网 aclID */
        @JsonProperty("networkAclID")
        private String networkAclID;

        /** 子网网段，掩码范围为 16-28 位 */
        @JsonProperty("CIDR")
        private String cIDR;

        /** 子网网关 */
        @JsonProperty("gatewayIP")
        private String gatewayIP;

        /** dhcpIP */
        @JsonProperty("dhcpIP")
        private String dhcpIP;

        /** 子网网段起始 IP */
        @JsonProperty("start")
        private String start;

        /** 子网网段结束 IP */
        @JsonProperty("end")
        private String end;

        /** 子网内可用 IPv4 数目 */
        @JsonProperty("availableIPCount")
        private Integer availableIPCount;

        /** 是否配置了ipv6网段，1 表示开启，0 表示未开启 */
        @JsonProperty("ipv6Enabled")
        private Integer ipv6Enabled;

        /** 是否开启 ipv6 */
        @JsonProperty("enableIpv6")
        private Boolean enableIpv6;

        /** 子网 Ipv6 网段，掩码范围为 16-28 位 */
        @JsonProperty("ipv6CIDR")
        private String ipv6CIDR;

        /** 子网内可用的起始 IPv6 地址 */
        @JsonProperty("ipv6Start")
        private String ipv6Start;

        /** 子网内可用的结束 IPv6 地址 */
        @JsonProperty("ipv6End")
        private String ipv6End;

        /** v6 网关地址 */
        @JsonProperty("ipv6GatewayIP")
        private String ipv6GatewayIP;

        /** DNS 服务器地址:默认为空；必须为正确的 IPv4 格式；重新触发 DHCP 后生效，最大数组长度为 4 */
        @JsonProperty("dnsList")
        private List<String> dnsList;

        /** 系统自带DNS服务器地址 */
        @JsonProperty("systemDnsList")
        private List<String> systemDnsList;

        /** NTP 服务器地址: 默认为空，必须为正确的域名或 IPv4 格式；重新触发 DHCP 后生效，最大数组长度为 4 */
        @JsonProperty("ntpList")
        private List<String> ntpList;

        /** 子网类型 :当前仅支持：0（普通子网）, 1（裸金属子网） */
        @JsonProperty("type")
        private Integer type;

        /** 创建时间 */
        @JsonProperty("createAt")
        private String createAt;

        /** 更新时间 */
        @JsonProperty("updateAt")
        private String updateAt;

        /** 企业项目 */
        @JsonProperty("projectID")
        private String projectID;

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public List<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        public void setAvailabilityZones(List<String> availabilityZones) {
            this.availabilityZones = availabilityZones;
        }

        public String getRouteTableID() {
            return this.routeTableID;
        }

        public void setRouteTableID(String routeTableID) {
            this.routeTableID = routeTableID;
        }

        public String getNetworkAclID() {
            return this.networkAclID;
        }

        public void setNetworkAclID(String networkAclID) {
            this.networkAclID = networkAclID;
        }

        public String getCIDR() {
            return this.cIDR;
        }

        public void setCIDR(String cIDR) {
            this.cIDR = cIDR;
        }

        public String getGatewayIP() {
            return this.gatewayIP;
        }

        public void setGatewayIP(String gatewayIP) {
            this.gatewayIP = gatewayIP;
        }

        public String getDhcpIP() {
            return this.dhcpIP;
        }

        public void setDhcpIP(String dhcpIP) {
            this.dhcpIP = dhcpIP;
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public Integer getAvailableIPCount() {
            return this.availableIPCount;
        }

        public void setAvailableIPCount(Integer availableIPCount) {
            this.availableIPCount = availableIPCount;
        }

        public Integer getIpv6Enabled() {
            return this.ipv6Enabled;
        }

        public void setIpv6Enabled(Integer ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
        }

        public Boolean getEnableIpv6() {
            return this.enableIpv6;
        }

        public void setEnableIpv6(Boolean enableIpv6) {
            this.enableIpv6 = enableIpv6;
        }

        public String getIpv6CIDR() {
            return this.ipv6CIDR;
        }

        public void setIpv6CIDR(String ipv6CIDR) {
            this.ipv6CIDR = ipv6CIDR;
        }

        public String getIpv6Start() {
            return this.ipv6Start;
        }

        public void setIpv6Start(String ipv6Start) {
            this.ipv6Start = ipv6Start;
        }

        public String getIpv6End() {
            return this.ipv6End;
        }

        public void setIpv6End(String ipv6End) {
            this.ipv6End = ipv6End;
        }

        public String getIpv6GatewayIP() {
            return this.ipv6GatewayIP;
        }

        public void setIpv6GatewayIP(String ipv6GatewayIP) {
            this.ipv6GatewayIP = ipv6GatewayIP;
        }

        public List<String> getDnsList() {
            return this.dnsList;
        }

        public void setDnsList(List<String> dnsList) {
            this.dnsList = dnsList;
        }

        public List<String> getSystemDnsList() {
            return this.systemDnsList;
        }

        public void setSystemDnsList(List<String> systemDnsList) {
            this.systemDnsList = systemDnsList;
        }

        public List<String> getNtpList() {
            return this.ntpList;
        }

        public void setNtpList(List<String> ntpList) {
            this.ntpList = ntpList;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getCreateAt() {
            return this.createAt;
        }

        public void setCreateAt(String createAt) {
            this.createAt = createAt;
        }

        public String getUpdateAt() {
            return this.updateAt;
        }

        public void setUpdateAt(String updateAt) {
            this.updateAt = updateAt;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }
    }
}
