package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 安全组规则详情。 */
public class CtvpcShowSgRuleApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcShowSgRuleApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/vpc/describe-security-group-rule",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ShowSgRuleResponse send(Credential credential, ShowSgRuleRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.securityGroupID != null) {
            ctReq.addParam("securityGroupID", request.securityGroupID);
            request.securityGroupID = null;
        }
        if (request.securityGroupRuleID != null) {
            ctReq.addParam("securityGroupRuleID", request.securityGroupRuleID);
            request.securityGroupRuleID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ShowSgRuleResponse.class);
    }

    public static class ShowSgRuleRequest {
        /** 区域id */
        @JsonProperty("regionID")
        private String regionID;

        /** 安全组 ID */
        @JsonProperty("securityGroupID")
        private String securityGroupID;

        /** 安全组规则 ID */
        @JsonProperty("securityGroupRuleID")
        private String securityGroupRuleID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        public String getSecurityGroupRuleID() {
            return this.securityGroupRuleID;
        }

        public void setSecurityGroupRuleID(String securityGroupRuleID) {
            this.securityGroupRuleID = securityGroupRuleID;
        }
    }

    public static class ShowSgRuleResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 返回结果 */
        @JsonProperty("returnObj")
        private ShowSgRuleReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ShowSgRuleReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ShowSgRuleReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ShowSgRuleReturnObjResponse {
        /** 出方向-egress、入方向-ingress */
        @JsonProperty("direction")
        private String direction;

        /** 优先级:0~100 */
        @JsonProperty("priority")
        private Integer priority;

        /** IP类型:IPv4、IPv6 */
        @JsonProperty("ethertype")
        private String ethertype;

        /** 协议: ANY、TCP、UDP、ICMP、ICMP6 */
        @JsonProperty("protocol")
        private String protocol;

        /** 接口范围/ICMP类型:1-65535 */
        @JsonProperty("range")
        private String range;

        /** 远端地址:0.0.0.0/0 */
        @JsonProperty("destCidrIp")
        private String destCidrIp;

        /** 安全组规则描述信息。 */
        @JsonProperty("description")
        private String description;

        /** 创建时间，UTC时间。 */
        @JsonProperty("createTime")
        private String createTime;

        /** 唯一标识ID */
        @JsonProperty("id")
        private String id;

        /** 安全组ID */
        @JsonProperty("securityGroupID")
        private String securityGroupID;

        /** 拒绝策略:允许-accept 拒绝-drop */
        @JsonProperty("action")
        private String action;

        /** 类型 */
        @JsonProperty("origin")
        private String origin;

        /** 远端安全组ID */
        @JsonProperty("remoteSecurityGroupID")
        private String remoteSecurityGroupID;

        /** 前缀列表ID */
        @JsonProperty("prefixListID")
        private String prefixListID;

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public String getEthertype() {
            return this.ethertype;
        }

        public void setEthertype(String ethertype) {
            this.ethertype = ethertype;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }

        public String getDestCidrIp() {
            return this.destCidrIp;
        }

        public void setDestCidrIp(String destCidrIp) {
            this.destCidrIp = destCidrIp;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getOrigin() {
            return this.origin;
        }

        public void setOrigin(String origin) {
            this.origin = origin;
        }

        public String getRemoteSecurityGroupID() {
            return this.remoteSecurityGroupID;
        }

        public void setRemoteSecurityGroupID(String remoteSecurityGroupID) {
            this.remoteSecurityGroupID = remoteSecurityGroupID;
        }

        public String getPrefixListID() {
            return this.prefixListID;
        }

        public void setPrefixListID(String prefixListID) {
            this.prefixListID = prefixListID;
        }
    }
}
