package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询路由表详情 */
public class CtvpcShowRouteTableApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcShowRouteTableApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/vpc/route-table/show", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ShowRouteTableResponse send(Credential credential, ShowRouteTableRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.routeTableID != null) {
            ctReq.addParam("routeTableID", request.routeTableID);
            request.routeTableID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ShowRouteTableResponse.class);
    }

    public static class ShowRouteTableRequest {
        /** 区域id */
        @JsonProperty("regionID")
        private String regionID;

        /** 路由表 id */
        @JsonProperty("routeTableID")
        private String routeTableID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getRouteTableID() {
            return this.routeTableID;
        }

        public void setRouteTableID(String routeTableID) {
            this.routeTableID = routeTableID;
        }
    }

    public static class ShowRouteTableResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 返回结果 */
        @JsonProperty("returnObj")
        private ShowRouteTableReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ShowRouteTableReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ShowRouteTableReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ShowRouteTableReturnObjResponse {
        /** 路由表名字 */
        @JsonProperty("name")
        private String name;

        /** 路由表描述 */
        @JsonProperty("description")
        private String description;

        /** 虚拟私有云 id */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 路由 id */
        @JsonProperty("id")
        private String id;

        /** 是否冻结 */
        @JsonProperty("freezing")
        private Boolean freezing;

        /** 路由表中的路由数 */
        @JsonProperty("routeRulesCount")
        private Integer routeRulesCount;

        /** 创建时间 */
        @JsonProperty("createdAt")
        private String createdAt;

        /** 更新时间 */
        @JsonProperty("updatedAt")
        private String updatedAt;

        /** 路由规则 id 列表 */
        @JsonProperty("routeRules")
        private List<String> routeRules;

        /** 子网配置详情 */
        @JsonProperty("subnetDetail")
        private List<ShowRouteTableReturnObjSubnetDetailResponse> subnetDetail;

        /** 路由表类型:0-子网路由表，2-网关路由表 */
        @JsonProperty("type")
        private Integer type;

        /** 路由表来源：default-系统默认; user-用户创建 */
        @JsonProperty("origin")
        private String origin;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Boolean getFreezing() {
            return this.freezing;
        }

        public void setFreezing(Boolean freezing) {
            this.freezing = freezing;
        }

        public Integer getRouteRulesCount() {
            return this.routeRulesCount;
        }

        public void setRouteRulesCount(Integer routeRulesCount) {
            this.routeRulesCount = routeRulesCount;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public List<String> getRouteRules() {
            return this.routeRules;
        }

        public void setRouteRules(List<String> routeRules) {
            this.routeRules = routeRules;
        }

        public List<ShowRouteTableReturnObjSubnetDetailResponse> getSubnetDetail() {
            return this.subnetDetail;
        }

        public void setSubnetDetail(
                List<ShowRouteTableReturnObjSubnetDetailResponse> subnetDetail) {
            this.subnetDetail = subnetDetail;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getOrigin() {
            return this.origin;
        }

        public void setOrigin(String origin) {
            this.origin = origin;
        }
    }

    public static class ShowRouteTableReturnObjSubnetDetailResponse {
        /** 路由下子网 id */
        @JsonProperty("id")
        private String id;

        /** 路由下子网名字 */
        @JsonProperty("name")
        private String name;

        /** ipv4 无类别域间路由 */
        @JsonProperty("cidr")
        private String cidr;

        /** ipv6 无类别域间路由 */
        @JsonProperty("ipv6Cidr")
        private String ipv6Cidr;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCidr() {
            return this.cidr;
        }

        public void setCidr(String cidr) {
            this.cidr = cidr;
        }

        public String getIpv6Cidr() {
            return this.ipv6Cidr;
        }

        public void setIpv6Cidr(String ipv6Cidr) {
            this.ipv6Cidr = ipv6Cidr;
        }
    }
}
