package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询网卡信息 */
public class CtvpcShowPortApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcShowPortApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/ports/show", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ShowPortResponse send(Credential credential, ShowPortRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.networkInterfaceID != null) {
            ctReq.addParam("networkInterfaceID", request.networkInterfaceID);
            request.networkInterfaceID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ShowPortResponse.class);
    }

    public static class ShowPortRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 虚拟网卡id */
        @JsonProperty("networkInterfaceID")
        private String networkInterfaceID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getNetworkInterfaceID() {
            return this.networkInterfaceID;
        }

        public void setNetworkInterfaceID(String networkInterfaceID) {
            this.networkInterfaceID = networkInterfaceID;
        }
    }

    public static class ShowPortResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private ShowPortReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ShowPortReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ShowPortReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ShowPortReturnObjResponse {
        /** 虚拟网名称 */
        @JsonProperty("networkInterfaceName")
        private String networkInterfaceName;

        /** 虚拟网id */
        @JsonProperty("networkInterfaceID")
        private String networkInterfaceID;

        /** 所属vpc */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 所属子网id */
        @JsonProperty("subnetID")
        private String subnetID;

        /** 网卡类型: 0 主网卡， 1 弹性网卡 */
        @JsonProperty("role")
        private Integer role;

        /** mac地址 */
        @JsonProperty("macAddress")
        private String macAddress;

        /** 主ip */
        @JsonProperty("primaryPrivateIp")
        private String primaryPrivateIp;

        /** ipv6地址 */
        @JsonProperty("ipv6Addresses")
        private List<String> ipv6Addresses;

        /** 关联的设备id */
        @JsonProperty("instanceID")
        private String instanceID;

        /** 设备类型 VM, BM, Other */
        @JsonProperty("instanceType")
        private String instanceType;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** 安全组ID列表 */
        @JsonProperty("securityGroupIds")
        private List<String> securityGroupIds;

        /** 辅助私网IP */
        @JsonProperty("secondaryPrivateIps")
        private List<String> secondaryPrivateIps;

        /** 是否启用DOWN, UP */
        @JsonProperty("adminStatus")
        private String adminStatus;

        /** 创建时间 */
        @JsonProperty("createdAt")
        private String createdAt;

        /** 更新时间 */
        @JsonProperty("updatedAt")
        private String updatedAt;

        /** 关联的eip信息 */
        @JsonProperty("associatedEip")
        private ShowPortReturnObjAssociatedEipResponse associatedEip;

        public String getNetworkInterfaceName() {
            return this.networkInterfaceName;
        }

        public void setNetworkInterfaceName(String networkInterfaceName) {
            this.networkInterfaceName = networkInterfaceName;
        }

        public String getNetworkInterfaceID() {
            return this.networkInterfaceID;
        }

        public void setNetworkInterfaceID(String networkInterfaceID) {
            this.networkInterfaceID = networkInterfaceID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public Integer getRole() {
            return this.role;
        }

        public void setRole(Integer role) {
            this.role = role;
        }

        public String getMacAddress() {
            return this.macAddress;
        }

        public void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public String getPrimaryPrivateIp() {
            return this.primaryPrivateIp;
        }

        public void setPrimaryPrivateIp(String primaryPrivateIp) {
            this.primaryPrivateIp = primaryPrivateIp;
        }

        public List<String> getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        public void setIpv6Addresses(List<String> ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
        }

        public String getInstanceID() {
            return this.instanceID;
        }

        public void setInstanceID(String instanceID) {
            this.instanceID = instanceID;
        }

        public String getInstanceType() {
            return this.instanceType;
        }

        public void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        public void setSecurityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
        }

        public List<String> getSecondaryPrivateIps() {
            return this.secondaryPrivateIps;
        }

        public void setSecondaryPrivateIps(List<String> secondaryPrivateIps) {
            this.secondaryPrivateIps = secondaryPrivateIps;
        }

        public String getAdminStatus() {
            return this.adminStatus;
        }

        public void setAdminStatus(String adminStatus) {
            this.adminStatus = adminStatus;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public ShowPortReturnObjAssociatedEipResponse getAssociatedEip() {
            return this.associatedEip;
        }

        public void setAssociatedEip(ShowPortReturnObjAssociatedEipResponse associatedEip) {
            this.associatedEip = associatedEip;
        }
    }

    public static class ShowPortReturnObjAssociatedEipResponse {
        /** eip id */
        @JsonProperty("id")
        private String id;

        /** eip名称 */
        @JsonProperty("name")
        private String name;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}
