package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查看高可用虚 IP 详情 */
public class CtvpcShowHavipApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcShowHavipApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/vpc/havip/show", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ShowHavipResponse send(Credential credential, ShowHavipRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.haVipID != null) {
            ctReq.addParam("haVipID", request.haVipID);
            request.haVipID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ShowHavipResponse.class);
    }

    public static class ShowHavipRequest {
        /** 资源池 ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 高可用虚 IP 的 ID */
        @JsonProperty("haVipID")
        private String haVipID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getHaVipID() {
            return this.haVipID;
        }

        public void setHaVipID(String haVipID) {
            this.haVipID = haVipID;
        }
    }

    public static class ShowHavipResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private ShowHavipReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ShowHavipReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ShowHavipReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ShowHavipReturnObjResponse {
        /** 高可用虚 IP 的 ID */
        @JsonProperty("id")
        private String id;

        /** IPv4 地址 */
        @JsonProperty("ipv4")
        private String ipv4;

        /** ipv6 地址 */
        @JsonProperty("ipv6")
        private String ipv6;

        /** 虚拟私有云的的 id */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 子网 id */
        @JsonProperty("subnetID")
        private String subnetID;

        /** 绑定实例相关信息 */
        @JsonProperty("instanceInfo")
        private List<ShowHavipReturnObjInstanceInfoResponse> instanceInfo;

        /** 绑定弹性 IP 相关信息 */
        @JsonProperty("networkInfo")
        private List<ShowHavipReturnObjNetworkInfoResponse> networkInfo;

        /** 绑定网卡信息 */
        @JsonProperty("bindPorts")
        private List<ShowHavipReturnObjBindPortsResponse> bindPorts;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getIpv4() {
            return this.ipv4;
        }

        public void setIpv4(String ipv4) {
            this.ipv4 = ipv4;
        }

        public String getIpv6() {
            return this.ipv6;
        }

        public void setIpv6(String ipv6) {
            this.ipv6 = ipv6;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public List<ShowHavipReturnObjInstanceInfoResponse> getInstanceInfo() {
            return this.instanceInfo;
        }

        public void setInstanceInfo(List<ShowHavipReturnObjInstanceInfoResponse> instanceInfo) {
            this.instanceInfo = instanceInfo;
        }

        public List<ShowHavipReturnObjNetworkInfoResponse> getNetworkInfo() {
            return this.networkInfo;
        }

        public void setNetworkInfo(List<ShowHavipReturnObjNetworkInfoResponse> networkInfo) {
            this.networkInfo = networkInfo;
        }

        public List<ShowHavipReturnObjBindPortsResponse> getBindPorts() {
            return this.bindPorts;
        }

        public void setBindPorts(List<ShowHavipReturnObjBindPortsResponse> bindPorts) {
            this.bindPorts = bindPorts;
        }
    }

    public static class ShowHavipReturnObjInstanceInfoResponse {
        /** 实例名 */
        @JsonProperty("instanceName")
        private String instanceName;

        /** 实例 ID */
        @JsonProperty("id")
        private String id;

        /** 实例私有 IP */
        @JsonProperty("privateIp")
        private String privateIp;

        /** 实例的 IPv6 地址, 可以为空字符串 */
        @JsonProperty("privateIpv6")
        private String privateIpv6;

        /** 实例公网 IP */
        @JsonProperty("publicIp")
        private String publicIp;

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPrivateIp() {
            return this.privateIp;
        }

        public void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public String getPrivateIpv6() {
            return this.privateIpv6;
        }

        public void setPrivateIpv6(String privateIpv6) {
            this.privateIpv6 = privateIpv6;
        }

        public String getPublicIp() {
            return this.publicIp;
        }

        public void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }
    }

    public static class ShowHavipReturnObjNetworkInfoResponse {
        /** 弹性 IP ID */
        @JsonProperty("eipID")
        private String eipID;

        public String getEipID() {
            return this.eipID;
        }

        public void setEipID(String eipID) {
            this.eipID = eipID;
        }
    }

    public static class ShowHavipReturnObjBindPortsResponse {
        /** 网卡 ID */
        @JsonProperty("portID")
        private String portID;

        /** keepalive 角色: master / slave */
        @JsonProperty("role")
        private String role;

        /** 创建时间 */
        @JsonProperty("createdAt")
        private String createdAt;

        public String getPortID() {
            return this.portID;
        }

        public void setPortID(String portID) {
            this.portID = portID;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }
    }
}
