package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 安全组规则检查 */
public class CtvpcSgRulePreCheckApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcSgRulePreCheckApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v4/vpc/pre-check-sg-rule", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public SgRulePreCheckResponse send(Credential credential, SgRulePreCheckRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(SgRulePreCheckResponse.class);
    }

    public static class SgRulePreCheckRequest {
        /** 区域 id */
        @JsonProperty("regionID")
        private String regionID;

        /** 安全组 ID。 */
        @JsonProperty("securityGroupID")
        private String securityGroupID;

        /** 规则信息 */
        @JsonProperty("securityGroupRule")
        private SgRulePreCheckSecurityGroupRuleRequest securityGroupRule;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        public SgRulePreCheckSecurityGroupRuleRequest getSecurityGroupRule() {
            return this.securityGroupRule;
        }

        public void setSecurityGroupRule(SgRulePreCheckSecurityGroupRuleRequest securityGroupRule) {
            this.securityGroupRule = securityGroupRule;
        }
    }

    public static class SgRulePreCheckSecurityGroupRuleRequest {
        /** 入方向 */
        @JsonProperty("direction")
        private String direction;

        /** 拒绝策略:允许-accept 拒绝-drop */
        @JsonProperty("action")
        private String action;

        /** 优先级:1~100，取值越小优先级越大 */
        @JsonProperty("priority")
        private Integer priority;

        /** 协议: ANY、TCP、UDP、ICMP(v4) */
        @JsonProperty("protocol")
        private String protocol;

        /** IP 类型:IPv4、IPv6 */
        @JsonProperty("ethertype")
        private String ethertype;

        /** 远端地址:0.0.0.0/0 */
        @JsonProperty("destCidrIp")
        private String destCidrIp;

        /** 安全组开放的传输层协议相关的源端端口范围 */
        @JsonProperty("range")
        private String range;

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getEthertype() {
            return this.ethertype;
        }

        public void setEthertype(String ethertype) {
            this.ethertype = ethertype;
        }

        public String getDestCidrIp() {
            return this.destCidrIp;
        }

        public void setDestCidrIp(String destCidrIp) {
            this.destCidrIp = destCidrIp;
        }

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }
    }

    public static class SgRulePreCheckResponse {
        /** 返回状态码（800 为成功，900 为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode 为 900 时的错误信息; statusCode 为 800 时为 success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode 为 900 时的错误信息; statusCode 为 800 时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode 为 900 时为业务细分错误码，三段式：product.module.code; statusCode 为 800 时为 SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private SgRulePreCheckReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public SgRulePreCheckReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(SgRulePreCheckReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class SgRulePreCheckReturnObjResponse {
        /** 和哪个规则重复 */
        @JsonProperty("sgRuleID")
        private String sgRuleID;

        public String getSgRuleID() {
            return this.sgRuleID;
        }

        public void setSgRuleID(String sgRuleID) {
            this.sgRuleID = sgRuleID;
        }
    }
}
