package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询用户专有网络列表 */
public class CtvpcNewVpcListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcNewVpcListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/vpc/new-list", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public NewVpcListResponse send(Credential credential, NewVpcListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.vpcID != null) {
            ctReq.addParam("vpcID", request.vpcID);
            request.vpcID = null;
        }
        if (request.vpcName != null) {
            ctReq.addParam("vpcName", request.vpcName);
            request.vpcName = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.projectID != null) {
            ctReq.addParam("projectID", request.projectID);
            request.projectID = null;
        }
        if (request.nextToken != null) {
            ctReq.addParam("nextToken", request.nextToken);
            request.nextToken = null;
        }
        if (request.maxResults != null) {
            ctReq.addParam("maxResults", String.valueOf(request.maxResults));
            request.maxResults = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(NewVpcListResponse.class);
    }

    public static class NewVpcListRequest {
        /** 资源池 ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 多个 VPC 的 ID 之间用半角逗号（,）隔开。 */
        @JsonProperty("vpcID")
        private String vpcID;

        /** vpc 名字 */
        @JsonProperty("vpcName")
        private String vpcName;

        /** 列表的页码，默认值为 1。 */
        @JsonProperty("pageNumber")
        private Integer pageNumber;

        /** 列表的页码，默认值为 1, 推荐使用该字段, pageNumber 后续会废弃 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 分页查询时每页的行数，最大值为 200，默认值为 10。 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 企业项目 ID，默认为0 */
        @JsonProperty("projectID")
        private String projectID;

        /** 下一页游标 */
        @JsonProperty("nextToken")
        private String nextToken;

        /** 最大分页数 */
        @JsonProperty("maxResults")
        private Integer maxResults;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getVpcName() {
            return this.vpcName;
        }

        public void setVpcName(String vpcName) {
            this.vpcName = vpcName;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public String getNextToken() {
            return this.nextToken;
        }

        public void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public Integer getMaxResults() {
            return this.maxResults;
        }

        public void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }
    }

    public static class NewVpcListResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private NewVpcListReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public NewVpcListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(NewVpcListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class NewVpcListReturnObjResponse {
        /** vpc 组 */
        @JsonProperty("vpcs")
        private List<NewVpcListReturnObjVpcsResponse> vpcs;

        /** 列表条目数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 分页查询时每页的行数。 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        public List<NewVpcListReturnObjVpcsResponse> getVpcs() {
            return this.vpcs;
        }

        public void setVpcs(List<NewVpcListReturnObjVpcsResponse> vpcs) {
            this.vpcs = vpcs;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class NewVpcListReturnObjVpcsResponse {
        /** vpc 示例 ID */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 名称 */
        @JsonProperty("name")
        private String name;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** CIDR */
        @JsonProperty("CIDR")
        private String cIDR;

        /** 是否开启 ipv6 */
        @JsonProperty("ipv6Enabled")
        private Boolean ipv6Enabled;

        /** 是否开启 ipv6 */
        @JsonProperty("enableIpv6")
        private Boolean enableIpv6;

        /** ipv6CIDRS */
        @JsonProperty("ipv6CIDRS")
        private List<String> ipv6CIDRS;

        /** 子网 id 列表 */
        @JsonProperty("subnetIDs")
        private List<String> subnetIDs;

        /** 网关 id 列表 */
        @JsonProperty("natGatewayIDs")
        private List<String> natGatewayIDs;

        /** 附加网段 */
        @JsonProperty("secondaryCIDRS")
        private List<String> secondaryCIDRS;

        /** 企业项目 ID，默认为0 */
        @JsonProperty("projectID")
        private String projectID;

        /** VPC关联的dhcp选项集 */
        @JsonProperty("dhcpOptionsSetID")
        private String dhcpOptionsSetID;

        /** vni */
        @JsonProperty("vni")
        private Integer vni;

        /** 是否开启 dns host name */
        @JsonProperty("dnsHostnamesEnabled")
        private Integer dnsHostnamesEnabled;

        /** 创建时间 */
        @JsonProperty("createdAt")
        private String createdAt;

        /** 更新时间 */
        @JsonProperty("updatedAt")
        private String updatedAt;

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getCIDR() {
            return this.cIDR;
        }

        public void setCIDR(String cIDR) {
            this.cIDR = cIDR;
        }

        public Boolean getIpv6Enabled() {
            return this.ipv6Enabled;
        }

        public void setIpv6Enabled(Boolean ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
        }

        public Boolean getEnableIpv6() {
            return this.enableIpv6;
        }

        public void setEnableIpv6(Boolean enableIpv6) {
            this.enableIpv6 = enableIpv6;
        }

        public List<String> getIpv6CIDRS() {
            return this.ipv6CIDRS;
        }

        public void setIpv6CIDRS(List<String> ipv6CIDRS) {
            this.ipv6CIDRS = ipv6CIDRS;
        }

        public List<String> getSubnetIDs() {
            return this.subnetIDs;
        }

        public void setSubnetIDs(List<String> subnetIDs) {
            this.subnetIDs = subnetIDs;
        }

        public List<String> getNatGatewayIDs() {
            return this.natGatewayIDs;
        }

        public void setNatGatewayIDs(List<String> natGatewayIDs) {
            this.natGatewayIDs = natGatewayIDs;
        }

        public List<String> getSecondaryCIDRS() {
            return this.secondaryCIDRS;
        }

        public void setSecondaryCIDRS(List<String> secondaryCIDRS) {
            this.secondaryCIDRS = secondaryCIDRS;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public String getDhcpOptionsSetID() {
            return this.dhcpOptionsSetID;
        }

        public void setDhcpOptionsSetID(String dhcpOptionsSetID) {
            this.dhcpOptionsSetID = dhcpOptionsSetID;
        }

        public Integer getVni() {
            return this.vni;
        }

        public void setVni(Integer vni) {
            this.vni = vni;
        }

        public Integer getDnsHostnamesEnabled() {
            return this.dnsHostnamesEnabled;
        }

        public void setDnsHostnamesEnabled(Integer dnsHostnamesEnabled) {
            this.dnsHostnamesEnabled = dnsHostnamesEnabled;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }
    }
}
