package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询用户专有网络下子网列表 */
public class CtvpcNewSubnetListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcNewSubnetListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/vpc/new-list-subnet", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public NewSubnetListResponse send(Credential credential, NewSubnetListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.clientToken != null) {
            ctReq.addParam("clientToken", request.clientToken);
            request.clientToken = null;
        }
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.vpcID != null) {
            ctReq.addParam("vpcID", request.vpcID);
            request.vpcID = null;
        }
        if (request.subnetID != null) {
            ctReq.addParam("subnetID", request.subnetID);
            request.subnetID = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.nextToken != null) {
            ctReq.addParam("nextToken", request.nextToken);
            request.nextToken = null;
        }
        if (request.maxResults != null) {
            ctReq.addParam("maxResults", String.valueOf(request.maxResults));
            request.maxResults = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(NewSubnetListResponse.class);
    }

    public static class NewSubnetListRequest {
        /** 客户端存根，用于保证订单幂等性, 长度 1 - 64 */
        @JsonProperty("clientToken")
        private String clientToken;

        /** 资源池 ID */
        @JsonProperty("regionID")
        private String regionID;

        /** VPC 的 ID */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 多个 subnet 的 ID 之间用半角逗号（,）隔开。 */
        @JsonProperty("subnetID")
        private String subnetID;

        /** 列表的页码，默认值为 1。 */
        @JsonProperty("pageNumber")
        private Integer pageNumber;

        /** 列表的页码，默认值为 1, 推荐使用该字段, pageNumber 后续会废弃 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 分页查询时每页的行数，最大值为 200，默认值为 10。 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 下一页游标 */
        @JsonProperty("nextToken")
        private String nextToken;

        /** 最大数量 */
        @JsonProperty("maxResults")
        private Integer maxResults;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getNextToken() {
            return this.nextToken;
        }

        public void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public Integer getMaxResults() {
            return this.maxResults;
        }

        public void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }
    }

    public static class NewSubnetListResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private NewSubnetListReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public NewSubnetListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(NewSubnetListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class NewSubnetListReturnObjResponse {
        /** subnets 组 */
        @JsonProperty("subnets")
        private List<NewSubnetListReturnObjSubnetsResponse> subnets;

        /** 列表条目数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 分页查询时每页的行数。 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        public List<NewSubnetListReturnObjSubnetsResponse> getSubnets() {
            return this.subnets;
        }

        public void setSubnets(List<NewSubnetListReturnObjSubnetsResponse> subnets) {
            this.subnets = subnets;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class NewSubnetListReturnObjSubnetsResponse {
        /** subnet ID */
        @JsonProperty("subnetID")
        private String subnetID;

        /** 名称 */
        @JsonProperty("name")
        private String name;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** VpcID */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 子网所在的可用区名 */
        @JsonProperty("availabilityZones")
        private List<String> availabilityZones;

        /** 子网路由表 ID */
        @JsonProperty("routeTableID")
        private String routeTableID;

        /** 子网 aclID */
        @JsonProperty("networkAclID")
        private String networkAclID;

        /** 子网网段，掩码范围为 16-28 位 */
        @JsonProperty("CIDR")
        private String cIDR;

        /** 子网网关 */
        @JsonProperty("gatewayIP")
        private String gatewayIP;

        /** dhcpIP */
        @JsonProperty("dhcpIP")
        private String dhcpIP;

        /** 子网网段起始 IP */
        @JsonProperty("start")
        private String start;

        /** 子网网段结束 IP */
        @JsonProperty("end")
        private String end;

        /** 子网内可用 IPv4 数目 */
        @JsonProperty("availableIPCount")
        private Integer availableIPCount;

        /** 是否配置了ipv6网段 */
        @JsonProperty("ipv6Enabled")
        private Integer ipv6Enabled;

        /** 是否开启 ipv6 */
        @JsonProperty("enableIpv6")
        private Boolean enableIpv6;

        /** 子网 Ipv6 网段，掩码范围为 16-28 位 */
        @JsonProperty("ipv6CIDR")
        private String ipv6CIDR;

        /** 子网内可用的起始 IPv6 地址 */
        @JsonProperty("ipv6Start")
        private String ipv6Start;

        /** 子网内可用的结束 IPv6 地址 */
        @JsonProperty("ipv6End")
        private String ipv6End;

        /** v6 网关地址 */
        @JsonProperty("ipv6GatewayIP")
        private String ipv6GatewayIP;

        /** DNS 服务器地址:默认为空；必须为正确的 IPv4 格式；重新触发 DHCP 后生效，最大数组长度为 4 */
        @JsonProperty("dnsList")
        private List<String> dnsList;

        /** 系统自带DNS服务器地址 */
        @JsonProperty("systemDnsList")
        private List<String> systemDnsList;

        /** NTP 服务器地址: 默认为空，必须为正确的域名或 IPv4 格式；重新触发 DHCP 后生效，最大数组长度为 4 */
        @JsonProperty("ntpList")
        private List<String> ntpList;

        /** 子网类型 :当前仅支持：0（普通子网）, 1（裸金属子网） */
        @JsonProperty("type")
        private Integer type;

        /** 更新时间 */
        @JsonProperty("updateAt")
        private String updateAt;

        /** 创建时间 */
        @JsonProperty("createAt")
        private String createAt;

        /** 企业项目 */
        @JsonProperty("projectID")
        private String projectID;

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public List<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        public void setAvailabilityZones(List<String> availabilityZones) {
            this.availabilityZones = availabilityZones;
        }

        public String getRouteTableID() {
            return this.routeTableID;
        }

        public void setRouteTableID(String routeTableID) {
            this.routeTableID = routeTableID;
        }

        public String getNetworkAclID() {
            return this.networkAclID;
        }

        public void setNetworkAclID(String networkAclID) {
            this.networkAclID = networkAclID;
        }

        public String getCIDR() {
            return this.cIDR;
        }

        public void setCIDR(String cIDR) {
            this.cIDR = cIDR;
        }

        public String getGatewayIP() {
            return this.gatewayIP;
        }

        public void setGatewayIP(String gatewayIP) {
            this.gatewayIP = gatewayIP;
        }

        public String getDhcpIP() {
            return this.dhcpIP;
        }

        public void setDhcpIP(String dhcpIP) {
            this.dhcpIP = dhcpIP;
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public Integer getAvailableIPCount() {
            return this.availableIPCount;
        }

        public void setAvailableIPCount(Integer availableIPCount) {
            this.availableIPCount = availableIPCount;
        }

        public Integer getIpv6Enabled() {
            return this.ipv6Enabled;
        }

        public void setIpv6Enabled(Integer ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
        }

        public Boolean getEnableIpv6() {
            return this.enableIpv6;
        }

        public void setEnableIpv6(Boolean enableIpv6) {
            this.enableIpv6 = enableIpv6;
        }

        public String getIpv6CIDR() {
            return this.ipv6CIDR;
        }

        public void setIpv6CIDR(String ipv6CIDR) {
            this.ipv6CIDR = ipv6CIDR;
        }

        public String getIpv6Start() {
            return this.ipv6Start;
        }

        public void setIpv6Start(String ipv6Start) {
            this.ipv6Start = ipv6Start;
        }

        public String getIpv6End() {
            return this.ipv6End;
        }

        public void setIpv6End(String ipv6End) {
            this.ipv6End = ipv6End;
        }

        public String getIpv6GatewayIP() {
            return this.ipv6GatewayIP;
        }

        public void setIpv6GatewayIP(String ipv6GatewayIP) {
            this.ipv6GatewayIP = ipv6GatewayIP;
        }

        public List<String> getDnsList() {
            return this.dnsList;
        }

        public void setDnsList(List<String> dnsList) {
            this.dnsList = dnsList;
        }

        public List<String> getSystemDnsList() {
            return this.systemDnsList;
        }

        public void setSystemDnsList(List<String> systemDnsList) {
            this.systemDnsList = systemDnsList;
        }

        public List<String> getNtpList() {
            return this.ntpList;
        }

        public void setNtpList(List<String> ntpList) {
            this.ntpList = ntpList;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getUpdateAt() {
            return this.updateAt;
        }

        public void setUpdateAt(String updateAt) {
            this.updateAt = updateAt;
        }

        public String getCreateAt() {
            return this.createAt;
        }

        public void setCreateAt(String createAt) {
            this.createAt = createAt;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }
    }
}
