package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询路由表列表 */
public class CtvpcNewRouteTableListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcNewRouteTableListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/vpc/route-table/new-list", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public NewRouteTableListResponse send(Credential credential, NewRouteTableListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.vpcID != null) {
            ctReq.addParam("vpcID", request.vpcID);
            request.vpcID = null;
        }
        if (request.queryContent != null) {
            ctReq.addParam("queryContent", request.queryContent);
            request.queryContent = null;
        }
        if (request.routeTableID != null) {
            ctReq.addParam("routeTableID", request.routeTableID);
            request.routeTableID = null;
        }
        if (request.type != null) {
            ctReq.addParam("type", String.valueOf(request.type));
            request.type = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(NewRouteTableListResponse.class);
    }

    public static class NewRouteTableListRequest {
        /** 区域id */
        @JsonProperty("regionID")
        private String regionID;

        /** 关联的vpcID */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 对路由表名字 / 路由表描述 / 路由表 id 进行模糊查询 */
        @JsonProperty("queryContent")
        private String queryContent;

        /** 路由表 id */
        @JsonProperty("routeTableID")
        private String routeTableID;

        /** 路由表类型:0-子网路由表；2-网关路由表 */
        @JsonProperty("type")
        private Integer type;

        /** 列表的页码，默认值为 1。 */
        @JsonProperty("pageNumber")
        private Integer pageNumber;

        /** 列表的页码，默认值为 1, 推荐使用该字段, pageNumber 后续会废弃 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 分页查询时每页的行数，最大值为 50，默认值为 10。 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getQueryContent() {
            return this.queryContent;
        }

        public void setQueryContent(String queryContent) {
            this.queryContent = queryContent;
        }

        public String getRouteTableID() {
            return this.routeTableID;
        }

        public void setRouteTableID(String routeTableID) {
            this.routeTableID = routeTableID;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class NewRouteTableListResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 返回结果 */
        @JsonProperty("returnObj")
        private NewRouteTableListReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public NewRouteTableListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(NewRouteTableListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class NewRouteTableListReturnObjResponse {
        /** 路由列表 */
        @JsonProperty("routeTables")
        private List<NewRouteTableListReturnObjRouteTablesResponse> routeTables;

        /** 列表条目数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 分页查询时每页的行数。 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        public List<NewRouteTableListReturnObjRouteTablesResponse> getRouteTables() {
            return this.routeTables;
        }

        public void setRouteTables(
                List<NewRouteTableListReturnObjRouteTablesResponse> routeTables) {
            this.routeTables = routeTables;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class NewRouteTableListReturnObjRouteTablesResponse {
        /** 路由表名字 */
        @JsonProperty("name")
        private String name;

        /** 路由表描述 */
        @JsonProperty("description")
        private String description;

        /** 虚拟私有云 id */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 路由 id */
        @JsonProperty("id")
        private String id;

        /** 是否冻结 */
        @JsonProperty("freezing")
        private Boolean freezing;

        /** 路由表中的路由数 */
        @JsonProperty("routeRulesCount")
        private Integer routeRulesCount;

        /** 创建时间 */
        @JsonProperty("createdAt")
        private String createdAt;

        /** 更新时间 */
        @JsonProperty("updatedAt")
        private String updatedAt;

        /** 路由表类型:0-子网路由表，2-网关路由表 */
        @JsonProperty("type")
        private Integer type;

        /** 路由表来源：default-系统默认; user-用户创建 */
        @JsonProperty("origin")
        private String origin;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Boolean getFreezing() {
            return this.freezing;
        }

        public void setFreezing(Boolean freezing) {
            this.freezing = freezing;
        }

        public Integer getRouteRulesCount() {
            return this.routeRulesCount;
        }

        public void setRouteRulesCount(Integer routeRulesCount) {
            this.routeRulesCount = routeRulesCount;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getOrigin() {
            return this.origin;
        }

        public void setOrigin(String origin) {
            this.origin = origin;
        }
    }
}
