package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询用户安全组列表。 */
public class CtvpcNewQuerySecurityGroupsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcNewQuerySecurityGroupsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/vpc/new-query-security-groups",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public NewQuerySecurityGroupsResponse send(
            Credential credential, NewQuerySecurityGroupsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.vpcID != null) {
            ctReq.addParam("vpcID", request.vpcID);
            request.vpcID = null;
        }
        if (request.queryContent != null) {
            ctReq.addParam("queryContent", request.queryContent);
            request.queryContent = null;
        }
        if (request.instanceID != null) {
            ctReq.addParam("instanceID", request.instanceID);
            request.instanceID = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.nextToken != null) {
            ctReq.addParam("nextToken", request.nextToken);
            request.nextToken = null;
        }
        if (request.maxResults != null) {
            ctReq.addParam("maxResults", String.valueOf(request.maxResults));
            request.maxResults = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(NewQuerySecurityGroupsResponse.class);
    }

    public static class NewQuerySecurityGroupsRequest {
        /** 区域id */
        @JsonProperty("regionID")
        private String regionID;

        /** 安全组所在的专有网络ID。 */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 【模糊查询】 安全组ID或名称 */
        @JsonProperty("queryContent")
        private String queryContent;

        /** 实例 ID */
        @JsonProperty("instanceID")
        private String instanceID;

        /** 列表的页码，默认值为 1。 */
        @JsonProperty("pageNumber")
        private Integer pageNumber;

        /** 列表的页码，默认值为 1, 推荐使用该字段, pageNumber 后续会废弃 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 分页查询时每页的行数，最大值为 50，默认值为 10。 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 下一页游标 */
        @JsonProperty("nextToken")
        private String nextToken;

        /** 最大数量 */
        @JsonProperty("maxResults")
        private Integer maxResults;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getQueryContent() {
            return this.queryContent;
        }

        public void setQueryContent(String queryContent) {
            this.queryContent = queryContent;
        }

        public String getInstanceID() {
            return this.instanceID;
        }

        public void setInstanceID(String instanceID) {
            this.instanceID = instanceID;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getNextToken() {
            return this.nextToken;
        }

        public void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public Integer getMaxResults() {
            return this.maxResults;
        }

        public void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }
    }

    public static class NewQuerySecurityGroupsResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 返回结果 */
        @JsonProperty("returnObj")
        private NewQuerySecurityGroupsReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public NewQuerySecurityGroupsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(NewQuerySecurityGroupsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class NewQuerySecurityGroupsReturnObjResponse {
        /** 安全组列表 */
        @JsonProperty("securityGroups")
        private List<NewQuerySecurityGroupsReturnObjSecurityGroupsResponse> securityGroups;

        /** 列表条目数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 分页查询时每页的行数。 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        public List<NewQuerySecurityGroupsReturnObjSecurityGroupsResponse> getSecurityGroups() {
            return this.securityGroups;
        }

        public void setSecurityGroups(
                List<NewQuerySecurityGroupsReturnObjSecurityGroupsResponse> securityGroups) {
            this.securityGroups = securityGroups;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class NewQuerySecurityGroupsReturnObjSecurityGroupsResponse {
        /** 安全组名称 */
        @JsonProperty("securityGroupName")
        private String securityGroupName;

        /** 项目ID */
        @JsonProperty("projectID")
        private String projectID;

        /** 安全组id */
        @JsonProperty("id")
        private String id;

        /** 相关云主机，该字段已经废弃，废弃后返回 0 */
        @JsonProperty("vmNum")
        private Integer vmNum;

        /** 表示是否是默认安全组 */
        @JsonProperty("origin")
        private String origin;

        /** vpc名称 */
        @JsonProperty("vpcName")
        private String vpcName;

        /** 安全组所属的专有网络。 */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 创建时间 */
        @JsonProperty("creationTime")
        private String creationTime;

        /** 安全组描述信息。 */
        @JsonProperty("description")
        private String description;

        /** 安全组规则信息 */
        @JsonProperty("securityGroupRuleList")
        private List<NewQuerySecurityGroupsReturnObjSecurityGroupsSecurityGroupRuleListResponse>
                securityGroupRuleList;

        public String getSecurityGroupName() {
            return this.securityGroupName;
        }

        public void setSecurityGroupName(String securityGroupName) {
            this.securityGroupName = securityGroupName;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Integer getVmNum() {
            return this.vmNum;
        }

        public void setVmNum(Integer vmNum) {
            this.vmNum = vmNum;
        }

        public String getOrigin() {
            return this.origin;
        }

        public void setOrigin(String origin) {
            this.origin = origin;
        }

        public String getVpcName() {
            return this.vpcName;
        }

        public void setVpcName(String vpcName) {
            this.vpcName = vpcName;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getCreationTime() {
            return this.creationTime;
        }

        public void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<NewQuerySecurityGroupsReturnObjSecurityGroupsSecurityGroupRuleListResponse>
                getSecurityGroupRuleList() {
            return this.securityGroupRuleList;
        }

        public void setSecurityGroupRuleList(
                List<NewQuerySecurityGroupsReturnObjSecurityGroupsSecurityGroupRuleListResponse>
                        securityGroupRuleList) {
            this.securityGroupRuleList = securityGroupRuleList;
        }
    }

    public static class NewQuerySecurityGroupsReturnObjSecurityGroupsSecurityGroupRuleListResponse {
        /** 出方向-egress、入方向-ingress */
        @JsonProperty("direction")
        private String direction;

        /** 优先级:0~100 */
        @JsonProperty("priority")
        private Integer priority;

        /** IP类型:IPv4、IPv6 */
        @JsonProperty("ethertype")
        private String ethertype;

        /** 协议: ANY、TCP、UDP、ICMP、ICMP6 */
        @JsonProperty("protocol")
        private String protocol;

        /** 接口范围/ICMP类型:1-65535 */
        @JsonProperty("range")
        private String range;

        /** 远端地址:0.0.0.0/0 */
        @JsonProperty("destCidrIp")
        private String destCidrIp;

        /** 安全组规则描述信息。 */
        @JsonProperty("description")
        private String description;

        /** 创建时间，UTC时间。 */
        @JsonProperty("createTime")
        private String createTime;

        /** 唯一标识ID */
        @JsonProperty("id")
        private String id;

        /** 安全组ID */
        @JsonProperty("securityGroupID")
        private String securityGroupID;

        /** 否 */
        @JsonProperty("action")
        private String action;

        /** 类型 */
        @JsonProperty("origin")
        private String origin;

        /** 远端安全组id */
        @JsonProperty("remoteSecurityGroupID")
        private String remoteSecurityGroupID;

        /** 前缀列表id */
        @JsonProperty("prefixListID")
        private String prefixListID;

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public String getEthertype() {
            return this.ethertype;
        }

        public void setEthertype(String ethertype) {
            this.ethertype = ethertype;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }

        public String getDestCidrIp() {
            return this.destCidrIp;
        }

        public void setDestCidrIp(String destCidrIp) {
            this.destCidrIp = destCidrIp;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getOrigin() {
            return this.origin;
        }

        public void setOrigin(String origin) {
            this.origin = origin;
        }

        public String getRemoteSecurityGroupID() {
            return this.remoteSecurityGroupID;
        }

        public void setRemoteSecurityGroupID(String remoteSecurityGroupID) {
            this.remoteSecurityGroupID = remoteSecurityGroupID;
        }

        public String getPrefixListID() {
            return this.prefixListID;
        }

        public void setPrefixListID(String prefixListID) {
            this.prefixListID = prefixListID;
        }
    }
}
