package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 修改安全组入方向规则的描述信息。该接口只能修改入方向描述信息。如果您需要修改安全组规则的策略、端口范围等信息，请在管理控制台修改。 */
public class CtvpcModifySgIngressRuleApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcModifySgIngressRuleApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/vpc/modify-security-group-ingress",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ModifySgIngressRuleResponse send(
            Credential credential, ModifySgIngressRuleRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ModifySgIngressRuleResponse.class);
    }

    public static class ModifySgIngressRuleRequest {
        /** 区域id */
        @JsonProperty("regionID")
        private String regionID;

        /** 安全组ID。 */
        @JsonProperty("securityGroupID")
        private String securityGroupID;

        /** 安全组规则ID。 */
        @JsonProperty("securityGroupRuleID")
        private String securityGroupRuleID;

        /**
         * 支持拉丁字母、中文、数字, 特殊字符：~!@#$%^&*()_-+= <>?:{},./;'[]·~！@#￥%……&*（） ——
         * -+={}\《》？：“”【】、；‘'，。、，不能以 http: / https: 开头，长度 0 - 128
         */
        @JsonProperty("description")
        private String description;

        /** 客户端存根，用于保证订单幂等性, 长度 1 - 64 */
        @JsonProperty("clientToken")
        private String clientToken;

        /** 拒绝策略:允许-accept 拒绝-drop */
        @JsonProperty("action")
        private String action;

        /** 优先级:1~100，取值越小优先级越大 */
        @JsonProperty("priority")
        private Integer priority;

        /** 协议: ANY、TCP、UDP、ICMP(v4) */
        @JsonProperty("protocol")
        private String protocol;

        /** 远端安全组id */
        @JsonProperty("remoteSecurityGroupID")
        private String remoteSecurityGroupID;

        /** cidr */
        @JsonProperty("destCidrIp")
        private String destCidrIp;

        /** 远端类型，0 表示 destCidrIp，1 表示 remoteSecurityGroupID, 2 表示 prefixlistID，默认为 0 */
        @JsonProperty("remoteType")
        private Integer remoteType;

        /** 前缀列表 */
        @JsonProperty("prefixListID")
        private String prefixListID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        public String getSecurityGroupRuleID() {
            return this.securityGroupRuleID;
        }

        public void setSecurityGroupRuleID(String securityGroupRuleID) {
            this.securityGroupRuleID = securityGroupRuleID;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getRemoteSecurityGroupID() {
            return this.remoteSecurityGroupID;
        }

        public void setRemoteSecurityGroupID(String remoteSecurityGroupID) {
            this.remoteSecurityGroupID = remoteSecurityGroupID;
        }

        public String getDestCidrIp() {
            return this.destCidrIp;
        }

        public void setDestCidrIp(String destCidrIp) {
            this.destCidrIp = destCidrIp;
        }

        public Integer getRemoteType() {
            return this.remoteType;
        }

        public void setRemoteType(Integer remoteType) {
            this.remoteType = remoteType;
        }

        public String getPrefixListID() {
            return this.prefixListID;
        }

        public void setPrefixListID(String prefixListID) {
            this.prefixListID = prefixListID;
        }
    }

    public static class ModifySgIngressRuleResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }
    }
}
