package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查看某个子网已使用IP */
public class CtvpcListSubnetUsedIPsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcListSubnetUsedIPsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/vpc/list-used-ips", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListSubnetUsedIPsResponse send(Credential credential, ListSubnetUsedIPsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.subnetID != null) {
            ctReq.addParam("subnetID", request.subnetID);
            request.subnetID = null;
        }
        if (request.ip != null) {
            ctReq.addParam("ip", request.ip);
            request.ip = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListSubnetUsedIPsResponse.class);
    }

    public static class ListSubnetUsedIPsRequest {
        /** 资源池 ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 子网 ID */
        @JsonProperty("subnetID")
        private String subnetID;

        /** 子网内的 IP 地址 */
        @JsonProperty("ip")
        private String ip;

        /** 列表的页码，默认值为 1。 */
        @JsonProperty("pageNumber")
        private Integer pageNumber;

        /** 列表的页码，默认值为 1, 推荐使用该字段, pageNumber 后续会废弃 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 分页查询时每页的行数，最大值为 50，默认值为 10。 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class ListSubnetUsedIPsResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private ListSubnetUsedIPsReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ListSubnetUsedIPsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListSubnetUsedIPsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListSubnetUsedIPsReturnObjResponse {
        /** 已使用的 IP 数组 */
        @JsonProperty("usedIPs")
        private List<ListSubnetUsedIPsReturnObjUsedIPsResponse> usedIPs;

        /** 列表条目数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 分页查询时每页的行数。 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        public List<ListSubnetUsedIPsReturnObjUsedIPsResponse> getUsedIPs() {
            return this.usedIPs;
        }

        public void setUsedIPs(List<ListSubnetUsedIPsReturnObjUsedIPsResponse> usedIPs) {
            this.usedIPs = usedIPs;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class ListSubnetUsedIPsReturnObjUsedIPsResponse {
        /** ipv4 地址 */
        @JsonProperty("ipv4Address")
        private String ipv4Address;

        /** ipv6 地址 */
        @JsonProperty("ipv6Address")
        private String ipv6Address;

        /** 用途中文描述:云主机, 裸金属, 高可用虚 IP, SNAT, 负载均衡, 预占内网 IP, 内网网关接口, system */
        @JsonProperty("useDesc")
        private String useDesc;

        /** 用途英文描述 */
        @JsonProperty("use")
        private String use;

        /** 扩展ipv4地址 */
        @JsonProperty("secondaryPrivateIpv4")
        private List<String> secondaryPrivateIpv4;

        /** 扩展ipv6地址 */
        @JsonProperty("secondaryPrivateIpv6")
        private List<String> secondaryPrivateIpv6;

        public String getIpv4Address() {
            return this.ipv4Address;
        }

        public void setIpv4Address(String ipv4Address) {
            this.ipv4Address = ipv4Address;
        }

        public String getIpv6Address() {
            return this.ipv6Address;
        }

        public void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        public String getUseDesc() {
            return this.useDesc;
        }

        public void setUseDesc(String useDesc) {
            this.useDesc = useDesc;
        }

        public String getUse() {
            return this.use;
        }

        public void setUse(String use) {
            this.use = use;
        }

        public List<String> getSecondaryPrivateIpv4() {
            return this.secondaryPrivateIpv4;
        }

        public void setSecondaryPrivateIpv4(List<String> secondaryPrivateIpv4) {
            this.secondaryPrivateIpv4 = secondaryPrivateIpv4;
        }

        public List<String> getSecondaryPrivateIpv6() {
            return this.secondaryPrivateIpv6;
        }

        public void setSecondaryPrivateIpv6(List<String> secondaryPrivateIpv6) {
            this.secondaryPrivateIpv6 = secondaryPrivateIpv6;
        }
    }
}
