package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询路由表规则列表 */
public class CtvpcListRouteTableRulesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcListRouteTableRulesApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/vpc/route-table/list-rules", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListRouteTableRulesResponse send(
            Credential credential, ListRouteTableRulesRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.routeTableID != null) {
            ctReq.addParam("routeTableID", request.routeTableID);
            request.routeTableID = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListRouteTableRulesResponse.class);
    }

    public static class ListRouteTableRulesRequest {
        /** 区域id */
        @JsonProperty("regionID")
        private String regionID;

        /** 路由表 id */
        @JsonProperty("routeTableID")
        private String routeTableID;

        /** 列表的页码，默认值为 1。 */
        @JsonProperty("pageNumber")
        private Integer pageNumber;

        /** 列表的页码，默认值为 1, 推荐使用该字段, pageNumber 后续会废弃 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 分页查询时每页的行数，最大值为 50，默认值为 10。 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getRouteTableID() {
            return this.routeTableID;
        }

        public void setRouteTableID(String routeTableID) {
            this.routeTableID = routeTableID;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class ListRouteTableRulesResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 列表条目数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 分页查询时每页的行数。 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        /** 返回结果 */
        @JsonProperty("returnObj")
        private List<ListRouteTableRulesReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }

        public List<ListRouteTableRulesReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<ListRouteTableRulesReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListRouteTableRulesReturnObjResponse {
        /** 下一跳设备 id */
        @JsonProperty("nextHopID")
        private String nextHopID;

        /** vpcpeering / havip / bm / vm / natgw/ igw6 / dc / ticc / vpngw / enic */
        @JsonProperty("nextHopType")
        private String nextHopType;

        /** 无类别域间路由 */
        @JsonProperty("destination")
        private String destination;

        /** 4 表示 ipv4, 6 表示 ipv6 */
        @JsonProperty("ipVersion")
        private Integer ipVersion;

        /** 规则描述 */
        @JsonProperty("description")
        private String description;

        /** 路由规则 id */
        @JsonProperty("routeRuleID")
        private String routeRuleID;

        public String getNextHopID() {
            return this.nextHopID;
        }

        public void setNextHopID(String nextHopID) {
            this.nextHopID = nextHopID;
        }

        public String getNextHopType() {
            return this.nextHopType;
        }

        public void setNextHopType(String nextHopType) {
            this.nextHopType = nextHopType;
        }

        public String getDestination() {
            return this.destination;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        public Integer getIpVersion() {
            return this.ipVersion;
        }

        public void setIpVersion(Integer ipVersion) {
            this.ipVersion = ipVersion;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getRouteRuleID() {
            return this.routeRuleID;
        }

        public void setRouteRuleID(String routeRuleID) {
            this.routeRuleID = routeRuleID;
        }
    }
}
