package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取ipv6地址段 */
public class CtvpcListIpv6CidrApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcListIpv6CidrApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/ipv6/list-cidrs", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListIpv6CidrResponse send(Credential credential, ListIpv6CidrRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListIpv6CidrResponse.class);
    }

    public static class ListIpv6CidrRequest {
        /** 区域ID */
        @JsonProperty("regionID")
        private String regionID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }
    }

    public static class ListIpv6CidrResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 请求 id */
        @JsonProperty("requestID")
        private String requestID;

        /** 业务数据 */
        @JsonProperty("returnObj")
        private List<ListIpv6CidrReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getRequestID() {
            return this.requestID;
        }

        public void setRequestID(String requestID) {
            this.requestID = requestID;
        }

        public List<ListIpv6CidrReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<ListIpv6CidrReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListIpv6CidrReturnObjResponse {
        /** 资源池 ID */
        @JsonProperty("regionID")
        private String regionID;

        /** ipv6 cidr, 当 addressPoolType 为 ctyun 时，该字段不显示 */
        @JsonProperty("ipv6CidrBlock")
        private String ipv6CidrBlock;

        /** ipv6 地址段 id */
        @JsonProperty("ipv6SegmentPoolID")
        private String ipv6SegmentPoolID;

        /** 地址段类型: custom / ctyun */
        @JsonProperty("addressPoolType")
        private String addressPoolType;

        /** isp */
        @JsonProperty("isp")
        private String isp;

        /** vpc ipv6 CIDR前缀长度 */
        @JsonProperty("vpcIpv6PrefixLen")
        private Integer vpcIpv6PrefixLen;

        /** subnet ipv6 CIDR前缀长度 */
        @JsonProperty("subnetIpv6PrefixLen")
        private Integer subnetIpv6PrefixLen;

        /** 可用数量 */
        @JsonProperty("availableBlockCount")
        private Integer availableBlockCount;

        /** 状态 */
        @JsonProperty("adminStatus")
        private Integer adminStatus;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        public void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public String getIpv6SegmentPoolID() {
            return this.ipv6SegmentPoolID;
        }

        public void setIpv6SegmentPoolID(String ipv6SegmentPoolID) {
            this.ipv6SegmentPoolID = ipv6SegmentPoolID;
        }

        public String getAddressPoolType() {
            return this.addressPoolType;
        }

        public void setAddressPoolType(String addressPoolType) {
            this.addressPoolType = addressPoolType;
        }

        public String getIsp() {
            return this.isp;
        }

        public void setIsp(String isp) {
            this.isp = isp;
        }

        public Integer getVpcIpv6PrefixLen() {
            return this.vpcIpv6PrefixLen;
        }

        public void setVpcIpv6PrefixLen(Integer vpcIpv6PrefixLen) {
            this.vpcIpv6PrefixLen = vpcIpv6PrefixLen;
        }

        public Integer getSubnetIpv6PrefixLen() {
            return this.subnetIpv6PrefixLen;
        }

        public void setSubnetIpv6PrefixLen(Integer subnetIpv6PrefixLen) {
            this.subnetIpv6PrefixLen = subnetIpv6PrefixLen;
        }

        public Integer getAvailableBlockCount() {
            return this.availableBlockCount;
        }

        public void setAvailableBlockCount(Integer availableBlockCount) {
            this.availableBlockCount = availableBlockCount;
        }

        public Integer getAdminStatus() {
            return this.adminStatus;
        }

        public void setAdminStatus(Integer adminStatus) {
            this.adminStatus = adminStatus;
        }
    }
}
