package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询高可用虚IP列表 */
public class CtvpcListHavipApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcListHavipApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v4/vpc/havip/list", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListHavipResponse send(Credential credential, ListHavipRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListHavipResponse.class);
    }

    public static class ListHavipRequest {
        /** 客户端存根，用于保证订单幂等性, 长度 1 - 64 */
        @JsonProperty("clientToken")
        private String clientToken;

        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 企业项目ID，默认为'0' */
        @JsonProperty("projectID")
        private String projectID;

        /**
         * 筛选条件,filters为一个表，{key:haVipID(vpcID,subnetID),value:xxx(筛选字段对应key的value)},具体见请求体body示例
         */
        @JsonProperty("filters")
        private List<ListHavipFiltersRequest> filters;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public List<ListHavipFiltersRequest> getFilters() {
            return this.filters;
        }

        public void setFilters(List<ListHavipFiltersRequest> filters) {
            this.filters = filters;
        }
    }

    public static class ListHavipFiltersRequest {
        /** 筛选字段的key，支持：haVipID，vpcID，subnetID */
        @JsonProperty("key")
        private String key;

        /** 筛选字段对应key的value */
        @JsonProperty("value")
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class ListHavipResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private List<ListHavipReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public List<ListHavipReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<ListHavipReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListHavipReturnObjResponse {
        /** 高可用虚IP的ID */
        @JsonProperty("id")
        private String id;

        /** IPv4地址 */
        @JsonProperty("ipv4")
        private String ipv4;

        /** ipv6 地址 */
        @JsonProperty("ipv6")
        private String ipv6;

        /** 虚拟私有云的的id */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 子网id */
        @JsonProperty("subnetID")
        private String subnetID;

        /** 绑定实例相关信息 */
        @JsonProperty("instanceInfo")
        private List<ListHavipReturnObjInstanceInfoResponse> instanceInfo;

        /** 绑定弹性 IP 相关信息 */
        @JsonProperty("networkInfo")
        private List<ListHavipReturnObjNetworkInfoResponse> networkInfo;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getIpv4() {
            return this.ipv4;
        }

        public void setIpv4(String ipv4) {
            this.ipv4 = ipv4;
        }

        public String getIpv6() {
            return this.ipv6;
        }

        public void setIpv6(String ipv6) {
            this.ipv6 = ipv6;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public List<ListHavipReturnObjInstanceInfoResponse> getInstanceInfo() {
            return this.instanceInfo;
        }

        public void setInstanceInfo(List<ListHavipReturnObjInstanceInfoResponse> instanceInfo) {
            this.instanceInfo = instanceInfo;
        }

        public List<ListHavipReturnObjNetworkInfoResponse> getNetworkInfo() {
            return this.networkInfo;
        }

        public void setNetworkInfo(List<ListHavipReturnObjNetworkInfoResponse> networkInfo) {
            this.networkInfo = networkInfo;
        }
    }

    public static class ListHavipReturnObjInstanceInfoResponse {
        /** 实例名 */
        @JsonProperty("instanceName")
        private String instanceName;

        /** 实例 ID */
        @JsonProperty("id")
        private String id;

        /** 实例私有 IP */
        @JsonProperty("privateIp")
        private String privateIp;

        /** 实例的 IPv6 地址, 可以为空字符串 */
        @JsonProperty("privateIpv6")
        private String privateIpv6;

        /** 实例公网 IP */
        @JsonProperty("publicIp")
        private String publicIp;

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPrivateIp() {
            return this.privateIp;
        }

        public void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public String getPrivateIpv6() {
            return this.privateIpv6;
        }

        public void setPrivateIpv6(String privateIpv6) {
            this.privateIpv6 = privateIpv6;
        }

        public String getPublicIp() {
            return this.publicIp;
        }

        public void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }
    }

    public static class ListHavipReturnObjNetworkInfoResponse {
        /** 弹性 IP ID */
        @JsonProperty("eipID")
        private String eipID;

        public String getEipID() {
            return this.eipID;
        }

        public void setEipID(String eipID) {
            this.eipID = eipID;
        }
    }
}
