package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查看 Acl 规则列表 */
public class CtvpcListAclRuleApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcListAclRuleApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/acl-rule/list", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListAclRuleResponse send(Credential credential, ListAclRuleRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.aclID != null) {
            ctReq.addParam("aclID", request.aclID);
            request.aclID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListAclRuleResponse.class);
    }

    public static class ListAclRuleRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** aclID */
        @JsonProperty("aclID")
        private String aclID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getAclID() {
            return this.aclID;
        }

        public void setAclID(String aclID) {
            this.aclID = aclID;
        }
    }

    public static class ListAclRuleResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private ListAclRuleReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ListAclRuleReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListAclRuleReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListAclRuleReturnObjResponse {
        /** id */
        @JsonProperty("aclID")
        private String aclID;

        /** 名称 */
        @JsonProperty("name")
        private String name;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** VPC */
        @JsonProperty("vpcID")
        private String vpcID;

        /** disable,enable */
        @JsonProperty("enabled")
        private String enabled;

        /** 入规则id数组 */
        @JsonProperty("inPolicyID")
        private List<String> inPolicyID;

        /** 出规则id数组 */
        @JsonProperty("outPolicyID")
        private List<String> outPolicyID;

        /** 出规则id数组 */
        @JsonProperty("inRules")
        private List<ListAclRuleReturnObjInRulesResponse> inRules;

        /** 出规则id数组 */
        @JsonProperty("outRules")
        private List<ListAclRuleReturnObjOutRulesResponse> outRules;

        /** 创建时间 */
        @JsonProperty("createdAt")
        private String createdAt;

        /** 更新时间 */
        @JsonProperty("updatedAt")
        private String updatedAt;

        /** acl 绑定的子网 id */
        @JsonProperty("subnetIDs")
        private List<String> subnetIDs;

        public String getAclID() {
            return this.aclID;
        }

        public void setAclID(String aclID) {
            this.aclID = aclID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getEnabled() {
            return this.enabled;
        }

        public void setEnabled(String enabled) {
            this.enabled = enabled;
        }

        public List<String> getInPolicyID() {
            return this.inPolicyID;
        }

        public void setInPolicyID(List<String> inPolicyID) {
            this.inPolicyID = inPolicyID;
        }

        public List<String> getOutPolicyID() {
            return this.outPolicyID;
        }

        public void setOutPolicyID(List<String> outPolicyID) {
            this.outPolicyID = outPolicyID;
        }

        public List<ListAclRuleReturnObjInRulesResponse> getInRules() {
            return this.inRules;
        }

        public void setInRules(List<ListAclRuleReturnObjInRulesResponse> inRules) {
            this.inRules = inRules;
        }

        public List<ListAclRuleReturnObjOutRulesResponse> getOutRules() {
            return this.outRules;
        }

        public void setOutRules(List<ListAclRuleReturnObjOutRulesResponse> outRules) {
            this.outRules = outRules;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public List<String> getSubnetIDs() {
            return this.subnetIDs;
        }

        public void setSubnetIDs(List<String> subnetIDs) {
            this.subnetIDs = subnetIDs;
        }
    }

    public static class ListAclRuleReturnObjInRulesResponse {
        /** aclRuleID */
        @JsonProperty("aclRuleID")
        private String aclRuleID;

        /** 类型,ingress, egress */
        @JsonProperty("direction")
        private String direction;

        /** 优先级 */
        @JsonProperty("priority")
        private Integer priority;

        /** all, icmp, tcp, udp, gre, icmp6 */
        @JsonProperty("protocol")
        private String protocol;

        /** ipv4, ipv6 */
        @JsonProperty("ipVersion")
        private String ipVersion;

        /** 开始和结束port以:隔开 */
        @JsonProperty("destinationPort")
        private String destinationPort;

        /** 开始和结束port以:隔开 */
        @JsonProperty("sourcePort")
        private String sourcePort;

        /** 类型,ingress, egress */
        @JsonProperty("sourceIpAddress")
        private String sourceIpAddress;

        /** 类型,ingress, egress */
        @JsonProperty("destinationIpAddress")
        private String destinationIpAddress;

        /** accept, drop */
        @JsonProperty("action")
        private String action;

        /** disable, enable */
        @JsonProperty("enabled")
        private String enabled;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        public String getAclRuleID() {
            return this.aclRuleID;
        }

        public void setAclRuleID(String aclRuleID) {
            this.aclRuleID = aclRuleID;
        }

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getIpVersion() {
            return this.ipVersion;
        }

        public void setIpVersion(String ipVersion) {
            this.ipVersion = ipVersion;
        }

        public String getDestinationPort() {
            return this.destinationPort;
        }

        public void setDestinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
        }

        public String getSourcePort() {
            return this.sourcePort;
        }

        public void setSourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
        }

        public String getSourceIpAddress() {
            return this.sourceIpAddress;
        }

        public void setSourceIpAddress(String sourceIpAddress) {
            this.sourceIpAddress = sourceIpAddress;
        }

        public String getDestinationIpAddress() {
            return this.destinationIpAddress;
        }

        public void setDestinationIpAddress(String destinationIpAddress) {
            this.destinationIpAddress = destinationIpAddress;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getEnabled() {
            return this.enabled;
        }

        public void setEnabled(String enabled) {
            this.enabled = enabled;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class ListAclRuleReturnObjOutRulesResponse {
        /** aclRuleID */
        @JsonProperty("aclRuleID")
        private String aclRuleID;

        /** 类型,ingress, egress */
        @JsonProperty("direction")
        private String direction;

        /** 优先级 */
        @JsonProperty("priority")
        private Integer priority;

        /** all, icmp, tcp, udp, gre, icmp6 */
        @JsonProperty("protocol")
        private String protocol;

        /** ipv4, ipv6 */
        @JsonProperty("ipVersion")
        private String ipVersion;

        /** 开始和结束port以:隔开 */
        @JsonProperty("destinationPort")
        private String destinationPort;

        /** 开始和结束port以:隔开 */
        @JsonProperty("sourcePort")
        private String sourcePort;

        /** 类型,ingress, egress */
        @JsonProperty("sourceIpAddress")
        private String sourceIpAddress;

        /** 类型,ingress, egress */
        @JsonProperty("destinationIpAddress")
        private String destinationIpAddress;

        /** accept, drop */
        @JsonProperty("action")
        private String action;

        /** disable, enable */
        @JsonProperty("enabled")
        private String enabled;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        public String getAclRuleID() {
            return this.aclRuleID;
        }

        public void setAclRuleID(String aclRuleID) {
            this.aclRuleID = aclRuleID;
        }

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getIpVersion() {
            return this.ipVersion;
        }

        public void setIpVersion(String ipVersion) {
            this.ipVersion = ipVersion;
        }

        public String getDestinationPort() {
            return this.destinationPort;
        }

        public void setDestinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
        }

        public String getSourcePort() {
            return this.sourcePort;
        }

        public void setSourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
        }

        public String getSourceIpAddress() {
            return this.sourceIpAddress;
        }

        public void setSourceIpAddress(String sourceIpAddress) {
            this.sourceIpAddress = sourceIpAddress;
        }

        public String getDestinationIpAddress() {
            return this.destinationIpAddress;
        }

        public void setDestinationIpAddress(String destinationIpAddress) {
            this.destinationIpAddress = destinationIpAddress;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getEnabled() {
            return this.enabled;
        }

        public void setEnabled(String enabled) {
            this.enabled = enabled;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}
