package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查看 Acl 列表信息 */
public class CtvpcListAclApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcListAclApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(ENDPOINT_NAME, "GET", "/v4/acl/list", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListAclResponse send(Credential credential, ListAclRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.aclID != null) {
            ctReq.addParam("aclID", request.aclID);
            request.aclID = null;
        }
        if (request.projectID != null) {
            ctReq.addParam("projectID", request.projectID);
            request.projectID = null;
        }
        if (request.name != null) {
            ctReq.addParam("name", request.name);
            request.name = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListAclResponse.class);
    }

    public static class ListAclRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** aclID */
        @JsonProperty("aclID")
        private String aclID;

        /** 企业项目 ID，默认为"0" */
        @JsonProperty("projectID")
        private String projectID;

        /** acl Name */
        @JsonProperty("name")
        private String name;

        /** 列表的页码，默认值为 1 */
        @JsonProperty("pageNumber")
        private Integer pageNumber;

        /** 列表的页码，默认值为 1, 推荐使用该字段, pageNumber 后续会废弃 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 分页查询时每页的行数，最大值为 50，默认值为 10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getAclID() {
            return this.aclID;
        }

        public void setAclID(String aclID) {
            this.aclID = aclID;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class ListAclResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 请求 id */
        @JsonProperty("requestID")
        private String requestID;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private ListAclReturnObjResponse returnObj;

        /** 列表条目数。 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 分页查询时每页的行数。 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 分页查询时总页数。 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getRequestID() {
            return this.requestID;
        }

        public void setRequestID(String requestID) {
            this.requestID = requestID;
        }

        public ListAclReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListAclReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class ListAclReturnObjResponse {
        /** acls */
        @JsonProperty("acls")
        private List<ListAclReturnObjAclsResponse> acls;

        public List<ListAclReturnObjAclsResponse> getAcls() {
            return this.acls;
        }

        public void setAcls(List<ListAclReturnObjAclsResponse> acls) {
            this.acls = acls;
        }
    }

    public static class ListAclReturnObjAclsResponse {
        /** acl id */
        @JsonProperty("aclID")
        private String aclID;

        /** acl 名称 */
        @JsonProperty("name")
        private String name;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** 是否启用acl管控lb流量 */
        @JsonProperty("applyToPublicLb")
        private Boolean applyToPublicLb;

        /** 虚拟私有云 id */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 是否启用，取值范围：disable,enable */
        @JsonProperty("enabled")
        private String enabled;

        /** 入规则id数组 */
        @JsonProperty("inPolicyID")
        private List<String> inPolicyID;

        /** 出规则id数组 */
        @JsonProperty("outPolicyID")
        private List<String> outPolicyID;

        /** 创建时间 */
        @JsonProperty("createdAt")
        private String createdAt;

        /** 更新时间 */
        @JsonProperty("updatedAt")
        private String updatedAt;

        /** acl 绑定的子网 id */
        @JsonProperty("subnetIDs")
        private List<String> subnetIDs;

        public String getAclID() {
            return this.aclID;
        }

        public void setAclID(String aclID) {
            this.aclID = aclID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Boolean getApplyToPublicLb() {
            return this.applyToPublicLb;
        }

        public void setApplyToPublicLb(Boolean applyToPublicLb) {
            this.applyToPublicLb = applyToPublicLb;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getEnabled() {
            return this.enabled;
        }

        public void setEnabled(String enabled) {
            this.enabled = enabled;
        }

        public List<String> getInPolicyID() {
            return this.inPolicyID;
        }

        public void setInPolicyID(List<String> inPolicyID) {
            this.inPolicyID = inPolicyID;
        }

        public List<String> getOutPolicyID() {
            return this.outPolicyID;
        }

        public void setOutPolicyID(List<String> outPolicyID) {
            this.outPolicyID = outPolicyID;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        public List<String> getSubnetIDs() {
            return this.subnetIDs;
        }

        public void setSubnetIDs(List<String> subnetIDs) {
            this.subnetIDs = subnetIDs;
        }
    }
}
