package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取安全组绑定机器列表 */
public class CtvpcGetSgAssociateVmsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcGetSgAssociateVmsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/vpc/get-sg-associate-vms", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetSgAssociateVmsResponse send(Credential credential, GetSgAssociateVmsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.securityGroupID != null) {
            ctReq.addParam("securityGroupID", request.securityGroupID);
            request.securityGroupID = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetSgAssociateVmsResponse.class);
    }

    public static class GetSgAssociateVmsRequest {
        /** 区域id */
        @JsonProperty("regionID")
        private String regionID;

        /** 安全组ID */
        @JsonProperty("securityGroupID")
        private String securityGroupID;

        /** 列表的页码，默认值为 1, 推荐使用该字段, pageNumber 后续会废弃 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 分页查询时每页的行数，最大值为 50，默认值为 10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class GetSgAssociateVmsResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 返回结果 */
        @JsonProperty("returnObj")
        private GetSgAssociateVmsReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public GetSgAssociateVmsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetSgAssociateVmsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class GetSgAssociateVmsReturnObjResponse {
        /** 业务数据 */
        @JsonProperty("results")
        private List<GetSgAssociateVmsReturnObjResultsResponse> results;

        /** 列表条目数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 分页查询时每页的行数。 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        public List<GetSgAssociateVmsReturnObjResultsResponse> getResults() {
            return this.results;
        }

        public void setResults(List<GetSgAssociateVmsReturnObjResultsResponse> results) {
            this.results = results;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class GetSgAssociateVmsReturnObjResultsResponse {
        /** 主机 ID */
        @JsonProperty("instanceID")
        private String instanceID;

        /** 主机名 */
        @JsonProperty("instanceName")
        private String instanceName;

        /** 主机类型：VM / BM */
        @JsonProperty("instanceType")
        private String instanceType;

        /** 主机状态 */
        @JsonProperty("instanceState")
        private String instanceState;

        /** 私有 ipv4 */
        @JsonProperty("privateIp")
        private String privateIp;

        /** 私有 ipv6 */
        @JsonProperty("privateIpv6")
        private String privateIpv6;

        public String getInstanceID() {
            return this.instanceID;
        }

        public void setInstanceID(String instanceID) {
            this.instanceID = instanceID;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getInstanceType() {
            return this.instanceType;
        }

        public void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public String getInstanceState() {
            return this.instanceState;
        }

        public void setInstanceState(String instanceState) {
            this.instanceState = instanceState;
        }

        public String getPrivateIp() {
            return this.privateIp;
        }

        public void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public String getPrivateIpv6() {
            return this.privateIpv6;
        }

        public void setPrivateIpv6(String privateIpv6) {
            this.privateIpv6 = privateIpv6;
        }
    }
}
