package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** VPC解绑Ipv6网段。 */
public class CtvpcDisassociateIpv6CidrsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcDisassociateIpv6CidrsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/vpc/disassociate-ipv6-cidrs",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DisassociateIpv6CidrsResponse send(
            Credential credential, DisassociateIpv6CidrsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DisassociateIpv6CidrsResponse.class);
    }

    public static class DisassociateIpv6CidrsRequest {
        /** 客户端存根，用于保证订单幂等性, 长度 1 - 64 */
        @JsonProperty("clientToken")
        private String clientToken;

        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** vpc id */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 是Array类型，里面的内容是String，要解绑的ipv6 cidr */
        @JsonProperty("ipv6CIDRs")
        private List<String> ipv6CIDRs;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public List<String> getIpv6CIDRs() {
            return this.ipv6CIDRs;
        }

        public void setIpv6CIDRs(List<String> ipv6CIDRs) {
            this.ipv6CIDRs = ipv6CIDRs;
        }
    }

    public static class DisassociateIpv6CidrsResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 请求 id */
        @JsonProperty("requestID")
        private String requestID;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getRequestID() {
            return this.requestID;
        }

        public void setRequestID(String requestID) {
            this.requestID = requestID;
        }
    }
}
