package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 创建一个专有网络VPC。 */
public class CtvpcCreateVpcApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcCreateVpcApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v4/vpc/create", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateVpc1Response send(Credential credential, CreateVpc1Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateVpc1Response.class);
    }

    public static class CreateVpc1Request {
        /** 客户端存根，用于保证订单幂等性, 长度 1 - 64 */
        @JsonProperty("clientToken")
        private String clientToken;

        /** 企业项目 ID，默认为0 */
        @JsonProperty("projectID")
        private String projectID;

        /** 资源池 ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 支持拉丁字母、中文、数字，下划线，连字符，中文 / 英文字母开头，不能以 http: / https: 开头，长度 2 - 32 */
        @JsonProperty("name")
        private String name;

        /**
         * 支持拉丁字母、中文、数字, 特殊字符：~!@#$%^&*()_-+= <>?:{},./;'[,]·！@#￥%……&*（） ——
         * -+={},《》？：“”【】、；‘'，。、，不能以 http: / https: 开头，长度 0 - 128
         */
        @JsonProperty("description")
        private String description;

        /**
         * VPC 的网段。建议您使用 192.168.0.0/16、172.16.0.0/12、10.0.0.0/8 三个 RFC 标准私网网段及其子网作为专有网络的主 IPv4
         * 网段，网段掩码有效范围为 8~28 位
         */
        @JsonProperty("CIDR")
        private String cIDR;

        /** 是否开启 IPv6 网段。取值：false（默认值）:不开启，true: 开启 */
        @JsonProperty("enableIpv6")
        private Boolean enableIpv6;

        /** ipv6 segment pool id，当 addressPoolType = custom 时，必传 */
        @JsonProperty("ipv6SegmentPoolID")
        private String ipv6SegmentPoolID;

        /** 地址类型：ctyun / custom */
        @JsonProperty("addressPoolType")
        private String addressPoolType;

        /** ipv6 地址段 */
        @JsonProperty("ipv6Cidr")
        private String ipv6Cidr;

        /**
         * isp，支持 chinatelecom / chinaunicom / chinamobile / bgp-3 / pro-crossline，当 addressPoolType
         * = ctyun 时，必传
         */
        @JsonProperty("ipv6Isp")
        private String ipv6Isp;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getCIDR() {
            return this.cIDR;
        }

        public void setCIDR(String cIDR) {
            this.cIDR = cIDR;
        }

        public Boolean getEnableIpv6() {
            return this.enableIpv6;
        }

        public void setEnableIpv6(Boolean enableIpv6) {
            this.enableIpv6 = enableIpv6;
        }

        public String getIpv6SegmentPoolID() {
            return this.ipv6SegmentPoolID;
        }

        public void setIpv6SegmentPoolID(String ipv6SegmentPoolID) {
            this.ipv6SegmentPoolID = ipv6SegmentPoolID;
        }

        public String getAddressPoolType() {
            return this.addressPoolType;
        }

        public void setAddressPoolType(String addressPoolType) {
            this.addressPoolType = addressPoolType;
        }

        public String getIpv6Cidr() {
            return this.ipv6Cidr;
        }

        public void setIpv6Cidr(String ipv6Cidr) {
            this.ipv6Cidr = ipv6Cidr;
        }

        public String getIpv6Isp() {
            return this.ipv6Isp;
        }

        public void setIpv6Isp(String ipv6Isp) {
            this.ipv6Isp = ipv6Isp;
        }
    }

    public static class CreateVpc1Response {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private CreateVpc1ReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public CreateVpc1ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateVpc1ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateVpc1ReturnObjResponse {
        /** vpc 示例 ID */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 创建时间 */
        @JsonProperty("createdAt")
        private String createdAt;

        /** 更新时间 */
        @JsonProperty("updatedAt")
        private String updatedAt;

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }
    }
}
