package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 创建安全组入向规则。 */
public class CtvpcCreateSgIngressRuleApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcCreateSgIngressRuleApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/vpc/create-security-group-ingress",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateSgIngressRuleResponse send(
            Credential credential, CreateSgIngressRuleRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateSgIngressRuleResponse.class);
    }

    public static class CreateSgIngressRuleRequest {
        /** 区域id */
        @JsonProperty("regionID")
        private String regionID;

        /** 安全组ID。 */
        @JsonProperty("securityGroupID")
        private String securityGroupID;

        /** 规则信息 */
        @JsonProperty("securityGroupRules")
        private List<CreateSgIngressRuleSecurityGroupRulesRequest> securityGroupRules;

        /** 客户端存根，用于保证订单幂等性, 长度 1 - 64 */
        @JsonProperty("clientToken")
        private String clientToken;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getSecurityGroupID() {
            return this.securityGroupID;
        }

        public void setSecurityGroupID(String securityGroupID) {
            this.securityGroupID = securityGroupID;
        }

        public List<CreateSgIngressRuleSecurityGroupRulesRequest> getSecurityGroupRules() {
            return this.securityGroupRules;
        }

        public void setSecurityGroupRules(
                List<CreateSgIngressRuleSecurityGroupRulesRequest> securityGroupRules) {
            this.securityGroupRules = securityGroupRules;
        }

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }
    }

    public static class CreateSgIngressRuleSecurityGroupRulesRequest {
        /** 入方向 */
        @JsonProperty("direction")
        private String direction;

        /** remote 类型，0 表示使用 cidr，1 表示使用远端安全组，默认为 0 */
        @JsonProperty("remoteType")
        private Integer remoteType;

        /** 远端安全组 id */
        @JsonProperty("remoteSecurityGroupID")
        private String remoteSecurityGroupID;

        /** 拒绝策略:允许-accept 拒绝-drop */
        @JsonProperty("action")
        private String action;

        /** 优先级:1~100，取值越小优先级越大 */
        @JsonProperty("priority")
        private Integer priority;

        /** 协议: ANY、TCP、UDP、ICMP(v4) */
        @JsonProperty("protocol")
        private String protocol;

        /** IP类型:IPv4、IPv6 */
        @JsonProperty("ethertype")
        private String ethertype;

        /** 远端地址:0.0.0.0/0 */
        @JsonProperty("destCidrIp")
        private String destCidrIp;

        /**
         * 支持拉丁字母、中文、数字, 特殊字符：~!@#$%^&*()_-+= <>?:"{},./;'[\]·！@#￥%……&*（） ——
         * -+={}\《》？：“”【】、；‘'，。、，不能以 http: / https: 开头，长度 0 - 128
         */
        @JsonProperty("description")
        private String description;

        /** 安全组开放的传输层协议相关的源端端口范围 */
        @JsonProperty("range")
        private String range;

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public Integer getRemoteType() {
            return this.remoteType;
        }

        public void setRemoteType(Integer remoteType) {
            this.remoteType = remoteType;
        }

        public String getRemoteSecurityGroupID() {
            return this.remoteSecurityGroupID;
        }

        public void setRemoteSecurityGroupID(String remoteSecurityGroupID) {
            this.remoteSecurityGroupID = remoteSecurityGroupID;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public void setPriority(Integer priority) {
            this.priority = priority;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getEthertype() {
            return this.ethertype;
        }

        public void setEthertype(String ethertype) {
            this.ethertype = ethertype;
        }

        public String getDestCidrIp() {
            return this.destCidrIp;
        }

        public void setDestCidrIp(String destCidrIp) {
            this.destCidrIp = destCidrIp;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }
    }

    public static class CreateSgIngressRuleResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 业务数据 */
        @JsonProperty("returnObj")
        private CreateSgIngressRuleReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public CreateSgIngressRuleReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateSgIngressRuleReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateSgIngressRuleReturnObjResponse {
        /** 安全组规则 id 列表 */
        @JsonProperty("sgRuleIDs")
        private List<String> sgRuleIDs;

        public List<String> getSgRuleIDs() {
            return this.sgRuleIDs;
        }

        public void setSgRuleIDs(List<String> sgRuleIDs) {
            this.sgRuleIDs = sgRuleIDs;
        }
    }
}
