package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 创建弹性网卡 */
public class CtvpcCreatePortApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcCreatePortApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v4/ports/create", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreatePortResponse send(Credential credential, CreatePortRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreatePortResponse.class);
    }

    public static class CreatePortRequest {
        /** 客户端存根，用于保证订单幂等性, 长度 1 - 64 */
        @JsonProperty("clientToken")
        private String clientToken;

        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 子网ID */
        @JsonProperty("subnetID")
        private String subnetID;

        /** 弹性网卡的主私有IP地址 */
        @JsonProperty("primaryPrivateIp")
        private String primaryPrivateIp;

        /** 为弹性网卡指定一个或多个IPv6地址 */
        @JsonProperty("ipv6Addresses")
        private List<String> ipv6Addresses;

        /** 加入一个或多个安全组。安全组和弹性网卡必须在同一个专有网络VPC中，最多同时支持 10 个 */
        @JsonProperty("securityGroupIds")
        private List<String> securityGroupIds;

        /** 指定私有IP地址数量，让ECS为您自动创建IP地址 */
        @JsonProperty("secondaryPrivateIpCount")
        private Integer secondaryPrivateIpCount;

        /** 指定私有IP地址，不能和secondaryPrivateIpCount同时指定 */
        @JsonProperty("secondaryPrivateIps")
        private List<String> secondaryPrivateIps;

        /** 支持拉丁字母、中文、数字，下划线，连字符，中文 / 英文字母开头，不能以 http: / https: 开头，长度 2 - 32 */
        @JsonProperty("name")
        private String name;

        /**
         * 支持拉丁字母、中文、数字, 特殊字符：~!@#$%^&*()_-+= <>?:{},./;'[]·！@#￥%……&*（） —— -+={}\《》？：“”【】、；‘'，。、，不能以
         * http: / https: 开头，长度 0 - 128
         */
        @JsonProperty("description")
        private String description;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public String getPrimaryPrivateIp() {
            return this.primaryPrivateIp;
        }

        public void setPrimaryPrivateIp(String primaryPrivateIp) {
            this.primaryPrivateIp = primaryPrivateIp;
        }

        public List<String> getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        public void setIpv6Addresses(List<String> ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
        }

        public List<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        public void setSecurityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
        }

        public Integer getSecondaryPrivateIpCount() {
            return this.secondaryPrivateIpCount;
        }

        public void setSecondaryPrivateIpCount(Integer secondaryPrivateIpCount) {
            this.secondaryPrivateIpCount = secondaryPrivateIpCount;
        }

        public List<String> getSecondaryPrivateIps() {
            return this.secondaryPrivateIps;
        }

        public void setSecondaryPrivateIps(List<String> secondaryPrivateIps) {
            this.secondaryPrivateIps = secondaryPrivateIps;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class CreatePortResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 返回结果 */
        @JsonProperty("returnObj")
        private CreatePortReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public CreatePortReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreatePortReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreatePortReturnObjResponse {
        /** vpc的id */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 子网id */
        @JsonProperty("subnetID")
        private String subnetID;

        /** 网卡id */
        @JsonProperty("networkInterfaceID")
        private String networkInterfaceID;

        /** 网卡名称 */
        @JsonProperty("networkInterfaceName")
        private String networkInterfaceName;

        /** mac地址 */
        @JsonProperty("macAddress")
        private String macAddress;

        /** 网卡描述 */
        @JsonProperty("description")
        private String description;

        /** IPv6地址列表 */
        @JsonProperty("ipv6Address")
        private List<String> ipv6Address;

        /** 安全组ID列表 */
        @JsonProperty("securityGroupIds")
        private List<String> securityGroupIds;

        /** 二级IP地址列表 */
        @JsonProperty("secondaryPrivateIps")
        private List<String> secondaryPrivateIps;

        /** 弹性网卡的主私有IP */
        @JsonProperty("privateIpAddress")
        private String privateIpAddress;

        /** 绑定的实例的所有者ID */
        @JsonProperty("instanceOwnerID")
        private String instanceOwnerID;

        /** 设备类型 VM, BM, Other */
        @JsonProperty("instanceType")
        private String instanceType;

        /** 绑定的实例ID */
        @JsonProperty("instanceID")
        private String instanceID;

        /** 创建时间 */
        @JsonProperty("createdAt")
        private String createdAt;

        /** 更新时间 */
        @JsonProperty("updatedAt")
        private String updatedAt;

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public String getNetworkInterfaceID() {
            return this.networkInterfaceID;
        }

        public void setNetworkInterfaceID(String networkInterfaceID) {
            this.networkInterfaceID = networkInterfaceID;
        }

        public String getNetworkInterfaceName() {
            return this.networkInterfaceName;
        }

        public void setNetworkInterfaceName(String networkInterfaceName) {
            this.networkInterfaceName = networkInterfaceName;
        }

        public String getMacAddress() {
            return this.macAddress;
        }

        public void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<String> getIpv6Address() {
            return this.ipv6Address;
        }

        public void setIpv6Address(List<String> ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        public List<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        public void setSecurityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = securityGroupIds;
        }

        public List<String> getSecondaryPrivateIps() {
            return this.secondaryPrivateIps;
        }

        public void setSecondaryPrivateIps(List<String> secondaryPrivateIps) {
            this.secondaryPrivateIps = secondaryPrivateIps;
        }

        public String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public String getInstanceOwnerID() {
            return this.instanceOwnerID;
        }

        public void setInstanceOwnerID(String instanceOwnerID) {
            this.instanceOwnerID = instanceOwnerID;
        }

        public String getInstanceType() {
            return this.instanceType;
        }

        public void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public String getInstanceID() {
            return this.instanceID;
        }

        public void setInstanceID(String instanceID) {
            this.instanceID = instanceID;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getUpdatedAt() {
            return this.updatedAt;
        }

        public void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }
    }
}
