package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 创建高可用虚IP */
public class CtvpcCreateHavipApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcCreateHavipApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v4/vpc/havip/create", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateHavipResponse send(Credential credential, CreateHavipRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateHavipResponse.class);
    }

    public static class CreateHavipRequest {
        /** 客户端存根，用于保证订单幂等性, 长度 1 - 64 */
        @JsonProperty("clientToken")
        private String clientToken;

        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** VPC的ID */
        @JsonProperty("networkID")
        private String networkID;

        /** 子网ID */
        @JsonProperty("subnetID")
        private String subnetID;

        /** ip地址 */
        @JsonProperty("ipAddress")
        private String ipAddress;

        /** 虚拟IP的类型，v4-IPv4类型虚IP，v6-IPv6类型虚IP。默认为v4 */
        @JsonProperty("vipType")
        private String vipType;

        /**
         * 支持拉丁字母、中文、数字, 特殊字符：~!@#$%^&*()_-+= <>?:'{},./;'[,]·！@#￥%……&*（） ——
         * -+={},《》？：“”【】、；‘'，。、，不能以 http: / https: 开头，长度 0 - 128
         */
        @JsonProperty("description")
        private String description;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getNetworkID() {
            return this.networkID;
        }

        public void setNetworkID(String networkID) {
            this.networkID = networkID;
        }

        public String getSubnetID() {
            return this.subnetID;
        }

        public void setSubnetID(String subnetID) {
            this.subnetID = subnetID;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public String getVipType() {
            return this.vipType;
        }

        public void setVipType(String vipType) {
            this.vipType = vipType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class CreateHavipResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private CreateHavipReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public CreateHavipReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateHavipReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateHavipReturnObjResponse {
        /** 高可用虚IP的ID */
        @JsonProperty("uuid")
        private String uuid;

        /** 高可用虚IP的地址 */
        @JsonProperty("ipv4")
        private String ipv4;

        /** 高可用虚IP的地址 */
        @JsonProperty("ipv6")
        private String ipv6;

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String getIpv4() {
            return this.ipv4;
        }

        public void setIpv4(String ipv4) {
            this.ipv4 = ipv4;
        }

        public String getIpv6() {
            return this.ipv6;
        }

        public void setIpv6(String ipv6) {
            this.ipv6 = ipv6;
        }
    }
}
