package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 网卡状态批量查询接口 */
public class CtvpcBatchCheckPortStatusApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcBatchCheckPortStatusApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/ports/check-status-batch", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public BatchCheckPortStatusResponse send(
            Credential credential, BatchCheckPortStatusRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.portIDs != null) {
            ctReq.addParam("portIDs", request.portIDs);
            request.portIDs = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(BatchCheckPortStatusResponse.class);
    }

    public static class BatchCheckPortStatusRequest {
        /** 区域id */
        @JsonProperty("regionID")
        private String regionID;

        /** 多个网卡用 , 拼接起来, port-id,port-id, 最多支持同时检查 10 个网卡 */
        @JsonProperty("portIDs")
        private String portIDs;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getPortIDs() {
            return this.portIDs;
        }

        public void setPortIDs(String portIDs) {
            this.portIDs = portIDs;
        }
    }

    public static class BatchCheckPortStatusResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private List<BatchCheckPortStatusReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public List<BatchCheckPortStatusReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<BatchCheckPortStatusReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class BatchCheckPortStatusReturnObjResponse {
        /** 网卡 id */
        @JsonProperty("id")
        private String id;

        /** 网卡状态,ready / unready / error / unknown */
        @JsonProperty("status")
        private String status;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}
