package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 多个网卡关联IPv6（批量时使用） */
public class CtvpcBatchAssignIPv6ToPortApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcBatchAssignIPv6ToPortApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v4/ports/batch-assign-ipv6", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public BatchAssignIPv6ToPortResponse send(
            Credential credential, BatchAssignIPv6ToPortRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(BatchAssignIPv6ToPortResponse.class);
    }

    public static class BatchAssignIPv6ToPortRequest {
        /** 客户端存根，用于保证订单幂等性, 长度 1 - 64 */
        @JsonProperty("clientToken")
        private String clientToken;

        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 网卡设置IPv6信息的列表 */
        @JsonProperty("data")
        private List<BatchAssignIPv6ToPortDataRequest> data;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public List<BatchAssignIPv6ToPortDataRequest> getData() {
            return this.data;
        }

        public void setData(List<BatchAssignIPv6ToPortDataRequest> data) {
            this.data = data;
        }
    }

    public static class BatchAssignIPv6ToPortDataRequest {
        /** 网卡ID */
        @JsonProperty("networkInterfaceID")
        private String networkInterfaceID;

        /** Ipv6地址数量，新增自动分配地址的IPv6的数量, 与 ipv6Addresses 二选一, 最多支持 1 个 */
        @JsonProperty("ipv6AddressesCount")
        private Integer ipv6AddressesCount;

        /** IPv6地址列表，新增指定地址的IPv6列表，与 ipv6AddressesCount 二选一, 最多支持 1 个 */
        @JsonProperty("ipv6Addresses")
        private List<String> ipv6Addresses;

        public String getNetworkInterfaceID() {
            return this.networkInterfaceID;
        }

        public void setNetworkInterfaceID(String networkInterfaceID) {
            this.networkInterfaceID = networkInterfaceID;
        }

        public Integer getIpv6AddressesCount() {
            return this.ipv6AddressesCount;
        }

        public void setIpv6AddressesCount(Integer ipv6AddressesCount) {
            this.ipv6AddressesCount = ipv6AddressesCount;
        }

        public List<String> getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        public void setIpv6Addresses(List<String> ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
        }
    }

    public static class BatchAssignIPv6ToPortResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }
    }
}
