package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** VPC 绑定Ipv6网段 */
public class CtvpcAssociateVpcIpv6CidrsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcAssociateVpcIpv6CidrsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v4/vpc/associate-ipv6-cidrs", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public AssociateVpcIpv6CidrsResponse send(
            Credential credential, AssociateVpcIpv6CidrsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(AssociateVpcIpv6CidrsResponse.class);
    }

    public static class AssociateVpcIpv6CidrsRequest {
        /** 客户端存根，用于保证订单幂等性， 长度 1 - 64 */
        @JsonProperty("clientToken")
        private String clientToken;

        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** vpc id */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 地址池类型: custom or ctyun */
        @JsonProperty("addressPoolType")
        private String addressPoolType;

        /** chinatelecom,chinamobile等, addressPoolType=ctyun时必传 */
        @JsonProperty("ipv6Isp")
        private String ipv6Isp;

        /** ipv6地址池ID */
        @JsonProperty("ipv6SegmentPoolID")
        private String ipv6SegmentPoolID;

        /** ipv6 CIDR */
        @JsonProperty("ipv6CIDR")
        private String ipv6CIDR;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getAddressPoolType() {
            return this.addressPoolType;
        }

        public void setAddressPoolType(String addressPoolType) {
            this.addressPoolType = addressPoolType;
        }

        public String getIpv6Isp() {
            return this.ipv6Isp;
        }

        public void setIpv6Isp(String ipv6Isp) {
            this.ipv6Isp = ipv6Isp;
        }

        public String getIpv6SegmentPoolID() {
            return this.ipv6SegmentPoolID;
        }

        public void setIpv6SegmentPoolID(String ipv6SegmentPoolID) {
            this.ipv6SegmentPoolID = ipv6SegmentPoolID;
        }

        public String getIpv6CIDR() {
            return this.ipv6CIDR;
        }

        public void setIpv6CIDR(String ipv6CIDR) {
            this.ipv6CIDR = ipv6CIDR;
        }
    }

    public static class AssociateVpcIpv6CidrsResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 请求 id */
        @JsonProperty("requestID")
        private String requestID;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getRequestID() {
            return this.requestID;
        }

        public void setRequestID(String requestID) {
            this.requestID = requestID;
        }
    }
}
