package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 克隆 Acl,仅实现acl的规则复制，不包括关联资源和相关属性 */
public class CtvpcAclCloneApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcAclCloneApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v4/acl/clone", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public AclCloneResponse send(Credential credential, AclCloneRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(AclCloneResponse.class);
    }

    public static class AclCloneRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 目标资源池，仅支持从4.0资源池复制到4.0资源池 */
        @JsonProperty("destRegionID")
        private String destRegionID;

        /** 源aclID */
        @JsonProperty("srcAclID")
        private String srcAclID;

        /** 目标资源池得到的acl归属的vpc */
        @JsonProperty("vpcID")
        private String vpcID;

        /** 支持拉丁字母、中文、数字，下划线，连字符，中文 / 英文字母开头，不能以 http: / https: 开头，长度 2 - 32 */
        @JsonProperty("name")
        private String name;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getDestRegionID() {
            return this.destRegionID;
        }

        public void setDestRegionID(String destRegionID) {
            this.destRegionID = destRegionID;
        }

        public String getSrcAclID() {
            return this.srcAclID;
        }

        public void setSrcAclID(String srcAclID) {
            this.srcAclID = srcAclID;
        }

        public String getVpcID() {
            return this.vpcID;
        }

        public void setVpcID(String vpcID) {
            this.vpcID = vpcID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class AclCloneResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 请求 id */
        @JsonProperty("requestID")
        private String requestID;

        /** 接口业务数据 */
        @JsonProperty("returnObj")
        private AclCloneReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getRequestID() {
            return this.requestID;
        }

        public void setRequestID(String requestID) {
            this.requestID = requestID;
        }

        public AclCloneReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(AclCloneReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class AclCloneReturnObjResponse {
        /** acl id */
        @JsonProperty("aclID")
        private String aclID;

        /** acl 名称 */
        @JsonProperty("name")
        private String name;

        public String getAclID() {
            return this.aclID;
        }

        public void setAclID(String aclID) {
            this.aclID = aclID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}
