package cn.ctyun.apis.tag;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Map;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 接口根据参数来对实例进行标签绑定或解绑。 */
public class Rds2UpdateLabelsWithProdInstIdApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2UpdateLabelsWithProdInstIdApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/RDS2/v2/open-api/tag/label", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateLabelsWithProdInstIdResponse send(
            Credential credential, UpdateLabelsWithProdInstIdRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateLabelsWithProdInstIdResponse.class);
    }

    public static class UpdateLabelsWithProdInstIdRequest {
        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例Id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 绑定的标签键值对集（绑定集） */
        @JsonProperty("bindKvMap")
        private Map<String, String> bindKvMap;

        /** 解绑的标签键值对集（解绑集） */
        @JsonProperty("unbindKvMap")
        private Map<String, String> unbindKvMap;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Map<String, String> getBindKvMap() {
            return bindKvMap;
        }

        public void setBindKvMap(Map<String, String> bindKvMap) {
            this.bindKvMap = bindKvMap;
        }

        public Map<String, String> getUnbindKvMap() {
            return unbindKvMap;
        }

        public void setUnbindKvMap(Map<String, String> unbindKvMap) {
            this.unbindKvMap = unbindKvMap;
        }
    }

    public static class UpdateLabelsWithProdInstIdResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private UpdateLabelsWithProdInstIdReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public UpdateLabelsWithProdInstIdReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateLabelsWithProdInstIdReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class UpdateLabelsWithProdInstIdReturnObjResponse {}
}
