package cn.ctyun.apis.tag;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 对批量实例进行标签的绑定或解绑。 */
public class Rds2UpdateBatchLabelsWithProdInstIdApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2UpdateBatchLabelsWithProdInstIdApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v2/open-api/tag/batch-label",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateBatchLabelsWithProdInstIdResponse send(
            Credential credential, UpdateBatchLabelsWithProdInstIdRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateBatchLabelsWithProdInstIdResponse.class);
    }

    public static class UpdateBatchLabelsWithProdInstIdRequest {
        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 操作类型，bind：绑定，unbind：解绑 */
        @JsonProperty("action")
        private String action;

        /** 实例Id数组 */
        @JsonProperty("outerProdInstIds")
        private List<String> outerProdInstIds;

        /** 标签对象数组 */
        @JsonProperty("labels")
        private List<UpdateBatchLabelsWithProdInstIdLabelsRequest> labels;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public List<String> getOuterProdInstIds() {
            return this.outerProdInstIds;
        }

        public void setOuterProdInstIds(List<String> outerProdInstIds) {
            this.outerProdInstIds = outerProdInstIds;
        }

        public List<UpdateBatchLabelsWithProdInstIdLabelsRequest> getLabels() {
            return this.labels;
        }

        public void setLabels(List<UpdateBatchLabelsWithProdInstIdLabelsRequest> labels) {
            this.labels = labels;
        }
    }

    public static class UpdateBatchLabelsWithProdInstIdLabelsRequest {
        /** 标签键 */
        @JsonProperty("key")
        private String key;

        /** 标签值 */
        @JsonProperty("value")
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class UpdateBatchLabelsWithProdInstIdResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private UpdateBatchLabelsWithProdInstIdReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public UpdateBatchLabelsWithProdInstIdReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateBatchLabelsWithProdInstIdReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class UpdateBatchLabelsWithProdInstIdReturnObjResponse {}
}
