package cn.ctyun.apis.tag;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询用户的所有标签。根据参数pageNow和pageSize以标签键数量为计数返回，标签键和标签值的对应关系为一对多。 */
public class Rds2GetUserAllLabelsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetUserAllLabelsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v2/open-api/tag/all-label",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetUserAllLabelsResponse send(Credential credential, GetUserAllLabelsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.pageNow != null) {
            ctReq.addParam("pageNow", String.valueOf(request.pageNow));
            request.pageNow = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetUserAllLabelsResponse.class);
    }

    public static class GetUserAllLabelsRequest {
        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 当前页，默认1 */
        @JsonProperty("pageNow")
        private Integer pageNow;

        /** 页大小，默认10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getPageNow() {
            return this.pageNow;
        }

        public void setPageNow(Integer pageNow) {
            this.pageNow = pageNow;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class GetUserAllLabelsResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetUserAllLabelsReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetUserAllLabelsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetUserAllLabelsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetUserAllLabelsReturnObjResponse {
        /** 总数 */
        @JsonProperty("total")
        private Integer total;
        
        /** 页面记录 */
        @JsonProperty("pageRecords")
        private java.util.List<PageRecord> pageRecords;
        
        public Integer getTotal() {
            return this.total;
        }
        
        public void setTotal(Integer total) {
            this.total = total;
        }
        
        public java.util.List<PageRecord> getPageRecords() {
            return this.pageRecords;
        }
        
        public void setPageRecords(java.util.List<PageRecord> pageRecords) {
            this.pageRecords = pageRecords;
        }
        
        public static class PageRecord {
            /** 标签键 */
            @JsonProperty("key")
            private String key;
            
            /** 标签数据 */
            @JsonProperty("data")
            private java.util.List<DataItem> data;
            
            public String getKey() {
                return this.key;
            }
            
            public void setKey(String key) {
                this.key = key;
            }
            
            public java.util.List<DataItem> getData() {
                return this.data;
            }
            
            public void setData(java.util.List<DataItem> data) {
                this.data = data;
            }
            
            public static class DataItem {
                /** 标签ID */
                @JsonProperty("labelId")
                private String labelId;
                
                /** 标签值 */
                @JsonProperty("value")
                private String value;
                
                public String getLabelId() {
                    return this.labelId;
                }
                
                public void setLabelId(String labelId) {
                    this.labelId = labelId;
                }
                
                public String getValue() {
                    return this.value;
                }
                
                public void setValue(String value) {
                    this.value = value;
                }
            }
        }
    }
}
