package cn.ctyun.apis.tag;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 根据实例Id来获取与实例绑定企业项目信息。 */
public class Rds2GetProjectIdByProdInstIdsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetProjectIdByProdInstIdsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/RDS2/v2/open-api/tag/project-resource",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetProjectIdByProdInstIdsResponse send(
            Credential credential, GetProjectIdByProdInstIdsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        for (String ele0 : request.outerProdInstIds) {
            if (ele0 != null) {
                ctReq.addParam("outerProdInstIds", ele0);
                ele0 = null;
            }
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetProjectIdByProdInstIdsResponse.class);
    }

    public static class GetProjectIdByProdInstIdsRequest {
        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例Id列表 */
        @JsonProperty("outerProdInstIds")
        private List<String> outerProdInstIds;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<String> getOuterProdInstIds() {
            return this.outerProdInstIds;
        }

        public void setOuterProdInstIds(List<String> outerProdInstIds) {
            this.outerProdInstIds = outerProdInstIds;
        }
    }

    public static class GetProjectIdByProdInstIdsResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private List<GetProjectIdByProdInstIdsReturnObjResponse> returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<GetProjectIdByProdInstIdsReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<GetProjectIdByProdInstIdsReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetProjectIdByProdInstIdsReturnObjResponse {
        /** 企业项目Id */
        @JsonProperty("projectId")
        private String projectId;

        /** 企业项目名 */
        @JsonProperty("projectName")
        private String projectName;

        /** 在此企业项目下的实例Id */
        @JsonProperty("instIds")
        private List<String> instIds;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public List<String> getInstIds() {
            return this.instIds;
        }

        public void setInstIds(List<String> instIds) {
            this.instIds = instIds;
        }
    }
}
