package cn.ctyun.apis.tag;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 根据提供的实例Id来查询实例绑定的所有标签信息。 */
public class Rds2GetLabelsByProdInstIdApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2GetLabelsByProdInstIdApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/RDS2/v2/open-api/tag/label", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetLabelsByProdInstIdResponse send(
            Credential credential, GetLabelsByProdInstIdRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetLabelsByProdInstIdResponse.class);
    }

    public static class GetLabelsByProdInstIdRequest {
        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例Id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class GetLabelsByProdInstIdResponse {
        /** 返回码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回消息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetLabelsByProdInstIdReturnObjResponse returnObj;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetLabelsByProdInstIdReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetLabelsByProdInstIdReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetLabelsByProdInstIdReturnObjResponse {
        private Integer total;

        private List<GetLabelsByProdInstIdReturnObjPageRecordsResponse> pageRecords;

        public Integer getTotal() {
            return total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<GetLabelsByProdInstIdReturnObjPageRecordsResponse> getPageRecords() {
            return pageRecords;
        }

        public void setPageRecords(List<GetLabelsByProdInstIdReturnObjPageRecordsResponse> pageRecords) {
            this.pageRecords = pageRecords;
        }
    }

    public static class GetLabelsByProdInstIdReturnObjPageRecordsResponse {
        private String labelId;

        private String value;

        private String key;

        private List<String> instIds;

        public String getLabelId() {
            return labelId;
        }

        public void setLabelId(String labelId) {
            this.labelId = labelId;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public List<String> getInstIds() {
            return instIds;
        }

        public void setInstIds(List<String> instIds) {
            this.instIds = instIds;
        }
    }
}
