package cn.ctyun.apis.security;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 创建RDS白名单分组 */
public class Rds2CreateRdsAccessWhiteListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2CreateRdsAccessWhiteListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/RDS2/v1/open-api/rds-manage/rds-access-white-list",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateRdsAccessWhiteListResponse send(
            Credential credential, CreateRdsAccessWhiteListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateRdsAccessWhiteListResponse.class);
    }

    public static class CreateRdsAccessWhiteListRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 白名单分组名（必须以小写字母开头，且必须以小写字母或数字结尾，可包含数字或下划线，不含其他特殊字符） */
        @JsonProperty("groupName")
        private String groupName;

        /** 白名单ip列表['192.168.203.130', '192.168.203.131', '192.168.203.132'] */
        @JsonProperty("groupWhiteList")
        private List<String> groupWhiteList;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public List<String> getGroupWhiteList() {
            return this.groupWhiteList;
        }

        public void setGroupWhiteList(List<String> groupWhiteList) {
            this.groupWhiteList = groupWhiteList;
        }
    }

    public static class CreateRdsAccessWhiteListResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回信息 */
        @JsonProperty("message")
        private String message;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}
