package cn.ctyun.apis.proxysql;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询RDS实例的数据库独享代理详情 */
public class Rds2QueryProxyInstanceDetailApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Rds2QueryProxyInstanceDetailApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/RDS2/v1/open-api/proxy/proxy-detail", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryProxyInstanceDetailResponse send(
            Credential credential, QueryProxyInstanceDetailRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.projectId != null) {
            ctReq.addHeader("project-id", request.projectId);
            request.projectId = null;
        }
        if (request.instId != null) {
            ctReq.addHeader("inst-id", request.instId);
            request.instId = null;
        }
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.outerProdInstId != null) {
            ctReq.addParam("outerProdInstId", request.outerProdInstId);
            request.outerProdInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryProxyInstanceDetailResponse.class);
    }

    public static class QueryProxyInstanceDetailRequest {
        /** 项目id */
        @JsonProperty("project-id")
        private String projectId;

        /** 实例id （和参数outerProdInstId保持一致） */
        @JsonProperty("inst-id")
        private String instId;

        /** 资源池regionId，比如实例在资源池A，则需要填写A资源池的regionId。 */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }
    }

    public static class QueryProxyInstanceDetailResponse {
        /**
         * 返回码<br>
         * 取值范围：0 成功; 2001 参数异常；3001 业务异常；5001 请求响应失败
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryProxyInstanceDetailReturnObjResponse returnObj;

        /** 返回信息 */
        @JsonProperty("message")
        private String message;

        /** 错误码。当接口失败时才返回具体错误编码，成功不返回或者为空 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public QueryProxyInstanceDetailReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryProxyInstanceDetailReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryProxyInstanceDetailReturnObjResponse {
        /** 代理数量 */
        @JsonProperty("instanceCount")
        private Integer instanceCount;

        /** 代理实例信息 */
        @JsonProperty("proxyInstanceVoList")
        private List<QueryProxyInstanceDetailReturnObjProxyInstanceVoListResponse>
                proxyInstanceVoList;

        /** 代理实例配置信息 */
        @JsonProperty("proxyConfigOutputVoList")
        private List<QueryProxyInstanceDetailReturnObjProxyConfigOutputVoListResponse>
                proxyConfigOutputVoList;

        public Integer getInstanceCount() {
            return this.instanceCount;
        }

        public void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public List<QueryProxyInstanceDetailReturnObjProxyInstanceVoListResponse>
        getProxyInstanceVoList() {
            return this.proxyInstanceVoList;
        }

        public void setProxyInstanceVoList(
                List<QueryProxyInstanceDetailReturnObjProxyInstanceVoListResponse>
                        proxyInstanceVoList) {
            this.proxyInstanceVoList = proxyInstanceVoList;
        }

        public List<QueryProxyInstanceDetailReturnObjProxyConfigOutputVoListResponse>
        getProxyConfigOutputVoList() {
            return this.proxyConfigOutputVoList;
        }

        public void setProxyConfigOutputVoList(
                List<QueryProxyInstanceDetailReturnObjProxyConfigOutputVoListResponse>
                        proxyConfigOutputVoList) {
            this.proxyConfigOutputVoList = proxyConfigOutputVoList;
        }
    }

    public static class QueryProxyInstanceDetailReturnObjProxyInstanceVoListResponse {
        /** 代理id */
        @JsonProperty("outerProxyInstId")
        private String outerProxyInstId;

        /** vpc网络id */
        @JsonProperty("vpcId")
        private String vpcId;

        /** 代理规格 '0: 单实例, 1:一主一从, 目前暂时只支持一主一从' */
        @JsonProperty("proxyType")
        private Integer proxyType;

        /** 主节点 AZ名称 */
        @JsonProperty("masterAzName")
        private String masterAzName;

        /** 主节点 AZ Id */
        @JsonProperty("masterAzId")
        private String masterAzId;

        /** 代理实例名称 */
        @JsonProperty("proxyInstName")
        private String proxyInstName;

        /** 0 正常 1 创建中 8 删除中 9已删除 26 白名单配置中 */
        @JsonProperty("proxyRunningStatus")
        private Integer proxyRunningStatus;

        /** 机器规格 */
        @JsonProperty("machineSpec")
        private String machineSpec;

        public String getOuterProxyInstId() {
            return this.outerProxyInstId;
        }

        public void setOuterProxyInstId(String outerProxyInstId) {
            this.outerProxyInstId = outerProxyInstId;
        }

        public String getVpcId() {
            return this.vpcId;
        }

        public void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public Integer getProxyType() {
            return this.proxyType;
        }

        public void setProxyType(Integer proxyType) {
            this.proxyType = proxyType;
        }

        public String getMasterAzName() {
            return this.masterAzName;
        }

        public void setMasterAzName(String masterAzName) {
            this.masterAzName = masterAzName;
        }

        public String getMasterAzId() {
            return this.masterAzId;
        }

        public void setMasterAzId(String masterAzId) {
            this.masterAzId = masterAzId;
        }

        public String getProxyInstName() {
            return this.proxyInstName;
        }

        public void setProxyInstName(String proxyInstName) {
            this.proxyInstName = proxyInstName;
        }

        public Integer getProxyRunningStatus() {
            return this.proxyRunningStatus;
        }

        public void setProxyRunningStatus(Integer proxyRunningStatus) {
            this.proxyRunningStatus = proxyRunningStatus;
        }

        public String getMachineSpec() {
            return this.machineSpec;
        }

        public void setMachineSpec(String machineSpec) {
            this.machineSpec = machineSpec;
        }
    }

    public static class QueryProxyInstanceDetailReturnObjProxyConfigOutputVoListResponse {
        /** 代理的后端数据库节点数量 */
        @JsonProperty("backendServerCount")
        private Integer backendServerCount;

        /** -1: 表示从未配置过; 0：ReadWriteSpliting 读写分离加密方式 */
        @JsonProperty("featureAttribute")
        private String featureAttribute;

        /** 事务拆分: 0：功能未开通 1：功能已开通 */
        @JsonProperty("transactionReadSqlRouteOptimizeStatus")
        private String transactionReadSqlRouteOptimizeStatus;

        /** 读权重分配模式: 自动分配(Standard), 自定义分配权重(Custom) */
        @JsonProperty("readOnlyInstanceDistributionType")
        private String readOnlyInstanceDistributionType;

        /** 连接池类型: 0：功能未开通 连接池类型: 1：事务级连接池 2：会话级连接池 */
        @JsonProperty("connectionPersist")
        private String connectionPersist;

        /** 读写分离中只读实例的最大延迟阈值 */
        @JsonProperty("readOnlyInstanceMaxDelayTime")
        private String readOnlyInstanceMaxDelayTime;

        /** 后端数据库服务节点的只读权重配置列表 */
        @JsonProperty("readOnlyInstanceWeight")
        private List<
                QueryProxyInstanceDetailReturnObjProxyConfigOutputVoListReadOnlyInstanceWeightResponse>
                readOnlyInstanceWeight;

        /** 代理实例主键Id */
        @JsonProperty("proxyInstId")
        private Integer proxyInstId;

        /** 是否绑定弹性IP，0：未绑定，1：已绑定 */
        @JsonProperty("eipStatus")
        private Integer eipStatus;

        /** 绑定的弹性IP */
        @JsonProperty("eip")
        private String eip;

        public Integer getBackendServerCount() {
            return this.backendServerCount;
        }

        public void setBackendServerCount(Integer backendServerCount) {
            this.backendServerCount = backendServerCount;
        }

        public String getFeatureAttribute() {
            return this.featureAttribute;
        }

        public void setFeatureAttribute(String featureAttribute) {
            this.featureAttribute = featureAttribute;
        }

        public String getTransactionReadSqlRouteOptimizeStatus() {
            return this.transactionReadSqlRouteOptimizeStatus;
        }

        public void setTransactionReadSqlRouteOptimizeStatus(
                String transactionReadSqlRouteOptimizeStatus) {
            this.transactionReadSqlRouteOptimizeStatus = transactionReadSqlRouteOptimizeStatus;
        }

        public String getReadOnlyInstanceDistributionType() {
            return this.readOnlyInstanceDistributionType;
        }

        public void setReadOnlyInstanceDistributionType(String readOnlyInstanceDistributionType) {
            this.readOnlyInstanceDistributionType = readOnlyInstanceDistributionType;
        }

        public String getConnectionPersist() {
            return this.connectionPersist;
        }

        public void setConnectionPersist(String connectionPersist) {
            this.connectionPersist = connectionPersist;
        }

        public String getReadOnlyInstanceMaxDelayTime() {
            return this.readOnlyInstanceMaxDelayTime;
        }

        public void setReadOnlyInstanceMaxDelayTime(String readOnlyInstanceMaxDelayTime) {
            this.readOnlyInstanceMaxDelayTime = readOnlyInstanceMaxDelayTime;
        }

        public List<
                QueryProxyInstanceDetailReturnObjProxyConfigOutputVoListReadOnlyInstanceWeightResponse>
        getReadOnlyInstanceWeight() {
            return this.readOnlyInstanceWeight;
        }

        public void setReadOnlyInstanceWeight(
                List<
                        QueryProxyInstanceDetailReturnObjProxyConfigOutputVoListReadOnlyInstanceWeightResponse>
                        readOnlyInstanceWeight) {
            this.readOnlyInstanceWeight = readOnlyInstanceWeight;
        }

        public Integer getProxyInstId() {
            return this.proxyInstId;
        }

        public void setProxyInstId(Integer proxyInstId) {
            this.proxyInstId = proxyInstId;
        }

        public Integer getEipStatus() {
            return this.eipStatus;
        }

        public void setEipStatus(Integer eipStatus) {
            this.eipStatus = eipStatus;
        }

        public String getEip() {
            return this.eip;
        }

        public void setEip(String eip) {
            this.eip = eip;
        }
    }

    public static
    class QueryProxyInstanceDetailReturnObjProxyConfigOutputVoListReadOnlyInstanceWeightResponse {
        /** 实例id */
        @JsonProperty("outerProdInstId")
        private String outerProdInstId;

        /** 数据库实例的节点ID */
        @JsonProperty("resId")
        private Integer resId;

        /** 节点对应的只读权重 */
        @JsonProperty("weight")
        private Integer weight;

        /** 实例id */
        @JsonProperty("prodInstId")
        private Integer prodInstId;

        public String getOuterProdInstId() {
            return this.outerProdInstId;
        }

        public void setOuterProdInstId(String outerProdInstId) {
            this.outerProdInstId = outerProdInstId;
        }

        public Integer getResId() {
            return this.resId;
        }

        public void setResId(Integer resId) {
            this.resId = resId;
        }

        public Integer getWeight() {
            return this.weight;
        }

        public void setWeight(Integer weight) {
            this.weight = weight;
        }

        public Integer getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(Integer prodInstId) {
            this.prodInstId = prodInstId;
        }
    }
}
